<?php
include 'includes/header.php';
include 'config.php';

$serviceId = $_GET['id'] ?? 'diagnostics';

// Try to fetch from database
$stmt = $conn->prepare("SELECT * FROM services WHERE slug = ? OR id = ?");
$stmt->execute([$serviceId, $serviceId]);
$db_service = $stmt->fetch();

if ($db_service) {
    // Sanitize featured image
    $img = $db_service['featured_image'];
    if (strpos($img, 'http://localhost:8000/storage/') === 0) {
        $img = str_replace('http://localhost:8000/storage/', 'storage/', $img);
    } elseif (strpos($img, 'http://127.0.0.1:8000/storage/') === 0) {
        $img = str_replace('http://127.0.0.1:8000/storage/', 'storage/', $img);
    }

    $service = [
        'title' => $db_service['title'],
        'desc' => $db_service['description'],
        'img' => $img ?: 'https://images.unsplash.com/photo-1544724569-5f546fd6f2b5?q=80&w=2074&auto=format&fit=crop',
        'benefits' => json_decode($db_service['benefits'] ?? '[]', true) ?: [],
        'includes' => json_decode($db_service['features'] ?? '[]', true) ?: [],
        'price' => $db_service['price_starting_from'] ? 'From $' . $db_service['price_starting_from'] : 'Quote Required'
    ];
} else {
    $servicesData = [
        'alignment' => [
            'title' => 'Wheel Alignment',
            'desc' => 'Precision steering and tire longevity start with perfect alignment. Our laser-guided system Ensures your wheels are perfectly parallel and perpendicular to the road.',
            'img' => 'https://media.istockphoto.com/id/1991968552/photo/car-wheel-alignment-is-in-progress-auto-camber-toe-check-fixing-sensor-during-suspension.jpg?s=612x612&w=0&k=20&c=pLzwZMYiOoVSXdS7tJ7K-90UmPWBAASzeMAz2Yam3CY=',
            'benefits' => ['Improved Fuel Efficiency', 'Extended Tire Life', 'Better Handling & Safety', 'Reduced Strain on Suspension'],
            'includes' => ['Front & Rear Camber Check', 'Caster & Toe Adjustment', 'Steering Wheel Centering', 'Suspension Integrity Inspection'],
            'price' => 'From $85'
        ],
        'diagnostics' => [
            'title' => 'Computer Diagnostics',
            'desc' => 'Modern cars are advanced computers on wheels. Our factory-level diagnostic tools interface with your vehicle’s ECU to pinpoint issues with surgical precision.',
            'img' => 'https://images.unsplash.com/photo-1544724569-5f546fd6f2b5?q=80&w=2074&auto=format&fit=crop',
            'benefits' => ['Fast Issue Identification', 'Prevents Guesswork', 'Full System Health Report', 'OEM Software Updates'],
            'includes' => ['OBD-II Scanning', 'Live Data Monitoring', 'Sensor Calibration', 'Full Fault Code Reset'],
            'price' => '$99 (Full Scan)'
        ],
        'brakes' => [
            'title' => 'Brake System Service',
            'desc' => 'Your safety is our priority. We service everything from daily commuter brakes to high-performance ceramic systems for track-day legends.',
            'img' => 'https://media.istockphoto.com/id/1193247877/photo/handsome-mechanic-in-uniform.jpg?s=612x612&w=0&k=20&c=ZDIuniZcHY0McW4Zc654glUrtTGa8A7U2X2enGM7_60=',
            'benefits' => ['Optimal Stopping Power', 'No Squealing or Vibrations', 'Safety Peace of Mind', 'Heat Dissipation Optimization'],
            'includes' => ['Pads & Rotors Assessment', 'Brake Fluid Flush (DOT 4/5.1)', 'Caliper Rebuilding', 'ABS System Check'],
            'price' => 'From $199'
        ],
        'tuneup' => [
            'title' => 'Full Tune-Up Service',
            'desc' => 'Restore your engine\'s peak efficiency and performance. Our comprehensive tune-up reaches every corner of your powertrain to ensure smooth operation.',
            'img' => 'https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?q=80&w=2072&auto=format&fit=crop',
            'benefits' => ['Restored Horsepower', 'Improved Fuel Economy', 'Smoother Idling', 'Lower Emissions'],
            'includes' => ['Spark Plug Replacement', 'Air Filter Change', 'Throttle Body Cleaning', 'Fuel System Analysis'],
            'price' => 'From $249'
        ],
        'ac' => [
            'title' => 'Air Conditioning Service',
            'desc' => 'Stay cool in the summer and clear-visioned in the winter. We provide full HVAC diagnostics, recharging, and leak repairs for all vehicle types.',
            'img' => 'https://media.istockphoto.com/id/1318616314/photo/car-air-conditioner-check-service-leak-detection-fill-refrigerant-device-and-meter-liquid.jpg?s=612x612&w=0&k=20&c=RP7G3XKWEKEyUnHBDkMtBVLK0YuZpYTWLgTR9PG96tQ=',
            'benefits' => ['Ice Cold Cabin Temps', 'Odor Elimination', 'Faster Defrosting', 'Quieter Compressor Operation'],
            'includes' => ['Refrigerant Recharge (R134a/R1234yf)', 'System Leak Test', 'Cabin Filter Replacement', 'Compressor Health Check'],
            'price' => 'From $120'
        ],
        'oil' => [
            'title' => 'Premium Oil Change',
            'desc' => 'The lifeblood of your engine deserves the best. We use only premium synthetic oils and OEM-spec filters to ensure maximum protection against wear.',
            'img' => 'https://images.unsplash.com/photo-1580273916550-e323be2ae537?q=80&w=2064&auto=format&fit=crop',
            'benefits' => ['Reduced Engine Friction', 'Extended Engine Life', 'Better Thermal Stability', 'Cleaner Internal Components'],
            'includes' => ['Full Synthetic Oil Change', 'Premium Filter Replacement', 'Multi-point Fluid Top-off', 'Chassis Lubrication'],
            'price' => '$75 - $150'
        ],
        'tires' => [
            'title' => 'Tire & Wheel Services',
            'desc' => 'Keep your grip on the road with professional tire care. From high-performance summer rubber to rugged off-road treads, we handle it all.',
            'img' => 'https://img.freepik.com/free-photo/muscular-man-is-fixing-car-s-wheel-with-special-tool-auto-service_613910-17086.jpg?semt=ais_user_personalization&w=740&q=80',
            'benefits' => ['Maximum Road Traction', 'Balanced Ride Quality', 'Prevent Uneven Wear', 'Safety in All Conditions'],
            'includes' => ['Professional Mounting', 'Precision Balancing', 'Patterned Rotation', 'TPMS Sensor Calibration'],
            'price' => 'From $25 / tire'
        ],
        'performance' => [
            'title' => 'Performance Enhancement',
            'desc' => 'Take your driving experience to the next level. We specialize in bolt-on upgrades, ECU remapping, and suspension tuning for enthusiasts.',
            'img' => 'https://img.freepik.com/free-photo/close-up-fuel-level-gauge-vehicle_23-2150163678.jpg?semt=ais_hybrid&w=740&q=80',
            'desc' => 'Unlock your vehicle\'s hidden potential. From track-day setups to street performance upgrades, our technicians specialize in high-end tuning.',
            'benefits' => ['Increased Torque & Power', 'Sharper Throttle Response', 'Enhanced Exhaust Note', 'Custom Handling Profile'],
            'includes' => ['ECU Software Remapping', 'Cold Air Intake Install', 'Performance Exhaust Systems', 'Suspension Coilover Setup'],
            'price' => 'By Consultation'
        ],
        'repair' => [
            'title' => 'Full Mechanical Repair',
            'desc' => 'From minor mechanical issues to major structural repairs, our master technicians handle the most complex automotive challenges with ease.',
            'img' => 'https://images.unsplash.com/photo-1487754180451-c456f719a1fc?q=80&w=2070&auto=format&fit=crop',
            'benefits' => ['OEM Part Accuracy', 'Long-term Reliability', 'Workmanship Warranty', 'Structural Integrity Restore'],
            'includes' => ['Transmission Overhaul', 'Engine Rebuilding', 'Electrical Mystery Solving', 'Drivetrain Component Repair'],
            'price' => 'Quote Required'
        ],
    ];

    $service = $servicesData[$serviceId] ?? $servicesData['diagnostics'];
}
?>

<main class="pt-32 pb-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- Hero -->
        <div class="relative h-[50vh] min-h-[400px] rounded-[3rem] overflow-hidden mb-16 border border-white/5 shadow-2xl">
            <img src="<?php echo $service['img']; ?>" class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-gradient-to-t from-primary via-primary/40 to-transparent"></div>
            <div class="absolute bottom-12 left-12 right-12">
                <div class="max-w-3xl">
                    <span class="text-accent font-bold uppercase tracking-widest text-sm mb-4 block">PREMIUM SERVICE</span>
                    <h1 class="text-5xl md:text-7xl font-black mb-4"><?php echo $service['title']; ?></h1>
                    <p class="text-xl text-gray-200"><?php echo $service['desc']; ?></p>
                </div>
            </div>
        </div>

        <div class="grid lg:grid-cols-3 gap-16">
            <!-- Details -->
            <div class="lg:col-span-2 space-y-12">
                <section>
                    <h2 class="text-3xl font-bold mb-8 flex items-center">
                        <span class="w-10 h-1 border-b-4 border-accent mr-4"></span> Key Benefits
                    </h2>
                    <div class="grid md:grid-cols-2 gap-6">
                        <?php foreach($service['benefits'] as $benefit): ?>
                            <div class="glass p-6 rounded-2xl flex items-start space-x-4 border-white/5">
                                <i class="fas fa-check-circle text-accent mt-1"></i>
                                <span class="font-bold"><?php echo $benefit; ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </section>

                <section>
                    <h2 class="text-3xl font-bold mb-8 flex items-center">
                        <span class="w-10 h-1 border-b-4 border-accent mr-4"></span> What's Included
                    </h2>
                    <ul class="space-y-4">
                        <?php foreach($service['includes'] as $item): ?>
                            <li class="flex items-center space-x-4 glass px-8 py-5 rounded-2xl border-white/5">
                                <div class="w-2 h-2 rounded-full bg-accent"></div>
                                <span class="text-text-muted font-medium"><?php echo $item; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </section>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-8">
                <!-- Pricing Card -->
                <div class="glass p-8 rounded-[2.5rem] border-accent/20 border text-center">
                    <h3 class="text-text-muted font-bold uppercase tracking-widest text-xs mb-4">ESTIMATED PRICE</h3>
                    <div class="text-5xl font-black mb-8"><?php echo $service['price']; ?></div>
                    <a href="contact.php?booking=<?php echo $serviceId; ?>" class="block w-full bg-accent hover:bg-accent-dark text-primary py-5 rounded-2xl font-black text-lg transition-all shadow-xl shadow-accent/20 mb-4">
                        Book This Service
                    </a>
                    <p class="text-xs text-text-muted">*Exact pricing depends on car make, model, and year. Contact for a firm quote.</p>
                </div>

                <!-- Expert Help -->
                <div class="glass p-8 rounded-[2.5rem] border-white/5">
                    <h4 class="text-xl font-bold mb-4">Need Expert Advice?</h4>
                    <p class="text-text-muted text-sm mb-6 leading-relaxed">Our master technicians are ready to discuss your car's needs and plan a maintenance schedule.</p>
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-white/5 rounded-full flex items-center justify-center text-accent">
                            <i class="fas fa-headset"></i>
                        </div>
                        <div>
                            <p class="text-sm font-bold">+1 (234) 567-890</p>
                            <p class="text-xs text-text-muted font-bold uppercase">Call For Consultation</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</main>

<?php include 'includes/footer.php'; ?>
