<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'repair-financing.php');
?>

<main class="overflow-hidden">
    <!-- Hero Section with Background Image -->
    <section class="relative min-h-[85vh] flex items-center pt-32 pb-20 mt-[-80px]">
        <div class="absolute inset-0 z-0">
            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQhrR3aA0giab1Qi1_hWgrUh3FEisiYaGnkNQ&s" 
                 alt="Repair Workshop Background" 
                 class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-primary/40 backdrop-blur-[1px]"></div>
            <div class="absolute inset-0 bg-gradient-to-b from-transparent via-primary/20 to-primary"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full text-center" 
             x-data="{ 
                loaded: false, 
                content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
                init() {
                    setTimeout(() => this.loaded = true, 100);
                }
             }">
            <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 translateY(20px)" x-transition:enter-end="opacity-100 translateY(0)">
                <span class="inline-block glass px-4 py-1.5 rounded-full text-accent text-sm font-bold tracking-wider mb-6 border border-accent/20 uppercase"
                      x-text="content.hero_badge || 'Service First, Pay Later'">
                    Service First, Pay Later
                </span>
                <h1 class="text-6xl md:text-7xl font-black mb-8 leading-tight max-w-4xl mx-auto text-white"
                    x-html="content.hero_title ? content.hero_title.replace('Pay Later', '<span class=\'text-gradient\'>Pay Later</span>') : 'Repair Now, <span class=\'text-gradient\'>Pay Later</span>. Keep Your Legend Moving.'">
                    Repair Now, <span class="text-gradient">Pay Later</span>. Keep Your Legend Moving.
                </h1>
                <p class="text-text-muted text-xl mb-12 leading-relaxed max-w-2xl mx-auto"
                   x-text="content.hero_description || 'Don\'t let unexpected repair costs keep your vehicle off the road. Our flexible financing solutions allow you to spread the cost of major repairs over manageable monthly installments.'">
                    Don't let unexpected repair costs keep your vehicle off the road. Our flexible financing solutions allow you to spread the cost of major repairs over manageable monthly installments.
                </p>
                
                <!-- Finance Helper Button -->
                <div class="flex justify-center mb-16">
                    <button class="bg-accent hover:bg-accent-dark text-primary px-14 py-6 rounded-2xl font-black text-2xl flex items-center space-x-4 transition-all hover:scale-105 shadow-2xl shadow-accent/20">
                        <span>Finance Helper</span>
                        <i class="fas fa-magic"></i>
                    </button>
                </div>

                <div class="flex justify-center -space-x-4 mb-20">
                    <div class="w-16 h-16 rounded-full border-4 border-primary bg-accent/20 flex items-center justify-center text-accent text-xl shadow-lg shadow-accent/10"><i class="fas fa-shield-alt"></i></div>
                    <div class="w-16 h-16 rounded-full border-4 border-primary bg-blue-500/20 flex items-center justify-center text-blue-400 text-xl shadow-lg shadow-blue-500/10"><i class="fas fa-check"></i></div>
                    <div class="w-16 h-16 rounded-full border-4 border-primary bg-green-500/20 flex items-center justify-center text-green-400 text-xl shadow-lg shadow-green-500/10"><i class="fas fa-clock"></i></div>
                </div>
            </div>
        </div>
    </section>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Content Section -->
        <section class="mb-32">
            <div class="grid lg:grid-cols-2 gap-16 items-center">
                <div class="space-y-8">
                    <h2 class="text-4xl font-black text-white" 
                        x-html="content.why_title ? content.why_title.replace('Repair Financing?', '<span class=\'text-accent\'>Repair Financing?</span>') : 'Why Choose <span class=\'text-accent\'>Repair Financing?</span>'">
                        Why Choose <span class="text-accent">Repair Financing?</span>
                    </h2>
                    <p class="text-text-muted text-lg leading-relaxed"
                       x-text="content.why_description || 'We understand that car maintenance can sometimes come at the most inconvenient times. Our automotive repair financing is designed to provide peace of mind and financial flexibility when you need it most.'">
                        We understand that car maintenance can sometimes come at the most inconvenient times. Our automotive repair financing is designed to provide peace of mind and financial flexibility when you need it most.
                    </p>
                    <ul class="space-y-6">
                        <li class="flex items-start space-x-4">
                            <div class="w-8 h-8 bg-accent/10 rounded-lg flex items-center justify-center text-accent mt-1">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div>
                                <h4 class="text-white font-bold text-lg">Instant Decisions</h4>
                                <p class="text-text-muted">Get approved in minutes at our service desk or online before your visit.</p>
                            </div>
                        </li>
                        <li class="flex items-start space-x-4">
                            <div class="w-8 h-8 bg-accent/10 rounded-lg flex items-center justify-center text-accent mt-1">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div>
                                <h4 class="text-white font-bold text-lg">0% Interest Options</h4>
                                <p class="text-text-muted">Available plans with 0% interest for up to 6 months for qualified customers.</p>
                            </div>
                        </li>
                        <li class="flex items-start space-x-4">
                            <div class="w-8 h-8 bg-accent/10 rounded-lg flex items-center justify-center text-accent mt-1">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div>
                                <h4 class="text-white font-bold text-lg">No Hard Credit Pull</h4>
                                <p class="text-text-muted">Checking your eligibility won't affect your credit score in most cases.</p>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="relative">
                    <div class="glass-card p-2 rounded-[3.5rem] border-white/10 group transition-all duration-500 hover:border-accent/40">
                        <img src="https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?q=80&w=2072&auto=format&fit=crop" 
                             alt="Professional Workshop" 
                             class="rounded-[3rem] w-full h-[450px] object-cover opacity-60 group-hover:opacity-80 transition-opacity">
                        <div class="absolute inset-0 bg-gradient-to-t from-primary/80 via-transparent to-transparent rounded-[3.5rem]"></div>
                        <div class="absolute bottom-12 left-12 right-12">
                            <div class="glass p-6 rounded-2xl border border-white/10 bg-black/40 backdrop-blur-md">
                                <p class="text-accent font-bold mb-2">Elite Mechanical Care</p>
                                <p class="text-sm text-gray-300">"The financing option saved me when my transmission failed unexpectedly. Highly recommended!" — Michael T.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- How it works -->
        <section class="py-24 border-t border-white/5">
            <div class="text-center mb-20">
                <h2 class="text-5xl font-black text-white" x-text="content.how_it_works_title || 'How it Works'">How it Works</h2>
                <div class="w-20 h-1 bg-accent mx-auto mt-6 rounded-full opacity-50"></div>
            </div>
            <div class="grid md:grid-cols-3 gap-12 text-center">
                <div class="relative group">
                    <div class="w-24 h-24 bg-white/5 rounded-[2.5rem] mx-auto flex items-center justify-center text-4xl font-black border border-white/10 mb-8 group-hover:bg-accent group-hover:text-primary transition-all duration-500 transform group-hover:rotate-12 shadow-xl group-hover:shadow-accent/20">1</div>
                    <h3 class="text-2xl font-bold mb-4 text-white" x-text="content.step1_title || 'Book Your Service'">Book Your Service</h3>
                    <p class="text-text-muted leading-relaxed" x-text="content.step1_desc || 'Schedule your mechanical repair or restoration through our standard booking portal or by calling us.'">Schedule your mechanical repair or restoration through our standard booking portal or by calling us.</p>
                </div>
                <div class="relative group">
                    <div class="w-24 h-24 bg-white/5 rounded-[2.5rem] mx-auto flex items-center justify-center text-4xl font-black border border-white/10 mb-8 group-hover:bg-accent group-hover:text-primary transition-all duration-500 transform group-hover:-rotate-12 shadow-xl group-hover:shadow-accent/20">2</div>
                    <h3 class="text-2xl font-bold mb-4 text-white" x-text="content.step2_title || 'Select Financing'">Select Financing</h3>
                    <p class="text-text-muted leading-relaxed" x-text="content.step2_desc || 'During checkout at the service desk or while booking online, choose the \'Financing\' option to apply.'">During checkout at the service desk or while booking online, choose the "Financing" option to apply.</p>
                </div>
                <div class="relative group">
                    <div class="w-24 h-24 bg-white/5 rounded-[2.5rem] mx-auto flex items-center justify-center text-4xl font-black border border-white/10 mb-8 group-hover:bg-accent group-hover:text-primary transition-all duration-500 transform group-hover:rotate-12 shadow-xl group-hover:shadow-accent/20">3</div>
                    <h3 class="text-2xl font-bold mb-4 text-white" x-text="content.step3_title || 'Ride With Peace'">Ride With Peace</h3>
                    <p class="text-text-muted leading-relaxed" x-text="content.step3_desc || 'Pick a payment plan tailored to your budget, ranging from 3 to 24 month options, and get back on the road.'">Pick a payment plan tailored to your budget, ranging from 3 to 24 month options, and get back on the road.</p>
                </div>
            </div>
        </section>
    </div>
</main>

<style>
@keyframes bounce-horizontal {
    0%, 100% { transform: translateX(0); }
    50% { transform: translateX(8px); }
}
.animate-bounce-horizontal {
    animation: bounce-horizontal 1s infinite;
}
</style>

<?php include 'includes/footer.php'; ?>
