    <!-- Footer -->
    <footer class="bg-secondary/50 pt-20 pb-10 border-t border-white/5">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-16">
                <!-- Brand -->
                <div class="space-y-6">
                    <a href="index.php" class="flex items-center space-x-2">
                        <div class="w-8 h-8 bg-accent rounded flex items-center justify-center">
                            <i class="fas fa-car-side text-primary text-sm"></i>
                        </div>
                        <span class="text-xl font-display font-bold tracking-tight">Ultimate<span class="text-accent">AutoCare</span></span>
                    </a>
                    <p class="text-text-muted leading-relaxed">
                        Precision engineering meets timeless classics. We specialize in keeping your modern vehicles running perfectly and restoring vintage legends.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="w-10 h-10 rounded-full glass flex items-center justify-center hover:bg-accent hover:text-primary transition-all">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full glass flex items-center justify-center hover:bg-accent hover:text-primary transition-all">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full glass flex items-center justify-center hover:bg-accent hover:text-primary transition-all">
                            <i class="fab fa-twitter"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h4 class="text-lg font-bold mb-6">Services</h4>
                    <ul class="space-y-4 text-text-muted">
                        <li><a href="service-detail.php?id=diagnostics" class="hover:text-accent transition-colors">Computer Diagnostics</a></li>
                        <li><a href="service-detail.php?id=brakes" class="hover:text-accent transition-colors">Brakes & Suspension</a></li>
                        <li><a href="service-detail.php?id=engine" class="hover:text-accent transition-colors">Engine Tune-up</a></li>
                        <li><a href="service-detail.php?id=ac" class="hover:text-accent transition-colors">AC Repair</a></li>
                    </ul>
                </div>

                <!-- Support -->
                <div>
                    <h4 class="text-lg font-bold mb-6">Support</h4>
                    <ul class="space-y-4 text-text-muted">
                        <li><a href="about.php" class="hover:text-accent transition-colors">About Us</a></li>
                        <li><a href="faq.php" class="hover:text-accent transition-colors">FAQs</a></li>
                        <li><a href="contact.php" class="hover:text-accent transition-colors">Contact Us</a></li>
                        <li><a href="privacy.php" class="hover:text-accent transition-colors">Privacy Policy</a></li>
                    </ul>
                </div>

                <!-- Newsletter -->
                <div>
                    <h4 class="text-lg font-bold mb-6">Newsletter</h4>
                    <p class="text-text-muted mb-4">Subscribe for car maintenance tips and new arrivals.</p>
                    <form class="space-y-3">
                        <div class="relative">
                            <input type="email" placeholder="Email address" 
                                   class="w-full bg-white/5 border border-white/10 rounded-lg py-3 px-4 focus:outline-none focus:border-accent transition-colors text-sm">
                        </div>
                        <button type="submit" class="w-full bg-accent hover:bg-accent-dark text-primary font-bold py-3 rounded-lg transition-all text-sm">
                            Subscribe Now
                        </button>
                    </form>
                </div>
            </div>

            <div class="border-t border-white/5 pt-8 flex flex-col md:row justify-between items-center text-sm text-text-muted space-y-4 md:space-y-0 text-center">
                <p>&copy; <?php echo date('Y'); ?> Ultimate Auto Care. All rights reserved.</p>
                <div class="flex space-x-6">
                    <span>Designed for Excellence</span>
                    <i class="fas fa-certificate text-accent"></i>
                </div>
            </div>
        </div>
    </footer>

    <script src="assets/js/api.js"></script>
</body>
</html>
