<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'contact.php');
?>

<main class="pt-32 pb-24" 
      x-data="{ 
        tab: 'booking',
        content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
        init() {
            // No longer need to fetch via API
        }
      }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-3 gap-12">
            
            <!-- Contact Info -->
            <div class="lg:col-span-1 space-y-8">
                <div>
                    <h1 class="text-5xl font-black mb-6" 
                        x-html="content.contact_title ? content.contact_title.replace('Touch', '<span class=\'text-gradient\'>Touch</span>') : 'Get in <span class=\'text-gradient\'>Touch</span>'">
                        Get in <span class="text-gradient">Touch</span>
                    </h1>
                    <p class="text-text-muted text-lg mb-8"
                       x-text="content.contact_subtitle || 'We\'re here to help with any questions about our services or available inventory.'">
                        We're here to help with any questions about our services or available inventory.
                    </p>
                </div>

                <div class="space-y-6">
                    <div class="flex items-start space-x-4 group">
                        <div class="w-12 h-12 glass rounded-xl flex items-center justify-center text-accent group-hover:bg-accent group-hover:text-primary transition-all">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div>
                            <h4 class="font-bold">Visit Our Showroom</h4>
                            <p class="text-text-muted" x-text="content.address || '5270 State Rd 7 North Lauderdale, FL 33319, USA'">5270 State Rd 7<br>North Lauderdale, FL 33319, USA</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4 group">
                        <div class="w-12 h-12 glass rounded-xl flex items-center justify-center text-accent group-hover:bg-accent group-hover:text-primary transition-all">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <div>
                            <h4 class="font-bold">Call Us</h4>
                            <a :href="'tel:' + (content.phone || '9544854688')" class="text-text-muted hover:text-accent" x-text="content.phone || '(954) 485-4688'">(954) 485-4688</a>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4 group">
                        <div class="w-12 h-12 glass rounded-xl flex items-center justify-center text-accent group-hover:bg-accent group-hover:text-primary transition-all">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div>
                            <h4 class="font-bold">Email Us</h4>
                            <a :href="'mailto:' + (content.email || 'ultimateautocare@gmail.com')" class="text-text-muted hover:text-accent" x-text="content.email || 'ultimateautocare@gmail.com'">ultimateautocare@gmail.com</a>
                        </div>
                    </div>
                </div>

                <!-- Operating Hours -->
                <div class="glass p-8 rounded-3xl border-white/5">
                    <h4 class="font-bold mb-6 flex items-center"><i class="fas fa-clock mr-3 text-accent"></i> Opening Hours</h4>
                    <ul class="space-y-3 text-sm">
                        <li class="flex justify-between">
                            <span class="text-text-muted">Monday - Friday</span>
                            <span class="font-bold">8:00 AM - 6:00 PM</span>
                        </li>
                        <li class="flex justify-between">
                            <span class="text-text-muted">Saturday</span>
                            <span class="font-bold">9:00 AM - 4:00 PM</span>
                        </li>
                        <li class="flex justify-between">
                            <span class="text-text-muted">Sunday</span>
                            <span class="font-bold text-accent">Closed</span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Forms -->
            <div class="lg:col-span-2">
                <div class="glass-card rounded-[3rem] p-4 sm:p-10">
                    <!-- Tabs -->
                    <div class="flex space-x-4 mb-10 bg-white/5 p-1.5 rounded-2xl">
                        <button @click="tab = 'booking'" :class="tab === 'booking' ? 'bg-accent text-primary' : 'text-white hover:bg-white/5'" class="flex-1 py-3 rounded-xl font-bold transition-all">
                            <i class="fas fa-calendar-alt mr-2"></i> Book Service
                        </button>
                        <button @click="tab = 'contact'" :class="tab === 'contact' ? 'bg-accent text-primary' : 'text-white hover:bg-white/5'" class="flex-1 py-3 rounded-xl font-bold transition-all">
                            <i class="fas fa-paper-plane mr-2"></i> General Inquiry
                        </button>
                    </div>

                    <!-- Booking Form -->
                    <form x-show="tab === 'booking'" class="space-y-6" x-transition:enter="transition ease-out duration-300">
                        <div class="grid md:grid-cols-3 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Full Name</label>
                                <input type="text" placeholder="John Doe" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Email Address</label>
                                <input type="email" placeholder="john@example.com" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Phone Number</label>
                                <input type="tel" placeholder="+1..." class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required>
                            </div>
                        </div>
                        <div class="grid md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Car Make & Model</label>
                                <input type="text" placeholder="e.g. 1995 Honda Civic" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Preferred Date & Time</label>
                                <input type="datetime-local" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent">
                            </div>
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-text-muted ml-1">Service Type</label>
                            <select class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent">
                                <option>General Maintenance</option>
                                <option>Oil Change</option>
                                <option>Brake Service</option>
                                <option>Diagnostics</option>
                                <option>Engine Repair</option>
                                <option>Performance Tuning</option>
                                <option>Restoration Consultation</option>
                            </select>
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-text-muted ml-1">Additional Details</label>
                            <textarea rows="4" placeholder="Tell us about the issue..." class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent"></textarea>
                        </div>
                        <button class="w-full bg-accent hover:bg-accent-dark text-primary py-5 rounded-2xl font-black text-xl transition-all shadow-xl shadow-accent/40">
                            Confirm Appointment Request
                        </button>
                    </form>

                    <!-- Contact Form -->
                    <form x-show="tab === 'contact'" class="space-y-6" x-transition:enter="transition ease-out duration-300">
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-text-muted ml-1">Full Name</label>
                            <input type="text" placeholder="John Doe" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required>
                        </div>
                        <div class="grid md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Email Address</label>
                                <input type="email" placeholder="john@example.com" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required>
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm font-bold text-text-muted ml-1">Subject</label>
                                <input type="text" placeholder="How can we help?" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent">
                            </div>
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-text-muted ml-1">Message</label>
                            <textarea rows="6" placeholder="Your message here..." class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 focus:outline-none focus:border-accent" required></textarea>
                        </div>
                        <button class="w-full bg-accent hover:bg-accent-dark text-primary py-5 rounded-2xl font-black text-xl transition-all shadow-xl shadow-accent/40">
                            Send Message
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>
