<?php include 'includes/header.php'; ?>

<main class="pt-32 pb-24 min-h-screen bg-primary relative overflow-hidden">
    <!-- Background Decor -->
    <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-accent/5 rounded-full blur-[120px] -z-10"></div>
    <div class="absolute bottom-0 left-0 w-[600px] h-[600px] bg-blue-500/5 rounded-full blur-[120px] -z-10"></div>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-12">
            <h1 class="text-5xl font-black mb-4 uppercase tracking-tighter">Apply for <span class="text-gradient">Financing</span></h1>
            <p class="text-text-muted max-w-2xl mx-auto">Please fill out this comprehensive application to receive a customized financing quote from our elite banking partners.</p>
        </div>

        <!-- Success / Error Messages -->
        <div id="form-success" class="hidden mb-8 bg-green-500/10 border border-green-500/30 rounded-3xl px-8 py-6 text-center">
            <i class="fas fa-check-circle text-green-400 text-4xl mb-4 block"></i>
            <h3 class="text-xl font-black text-green-400 mb-2">Application Submitted!</h3>
            <p class="text-green-300 text-sm" id="success-message"></p>
        </div>
        <div id="form-error" class="hidden mb-8 bg-red-500/10 border border-red-500/30 rounded-3xl px-6 py-4 text-red-400 text-sm" id="error-message"></div>

        <form id="financing-form" x-data="{ 
            step: 1, 
            humanVerified: false,
            needsPriorAddress: false,
            submitting: false,
            nextStep() { if(this.step < 6) this.step++ },
            prevStep() { if(this.step > 1) this.step-- }
        }" class="glass-card rounded-[3rem] p-8 md:p-14 border-white/10 shadow-2xl relative overflow-hidden">
            
            <!-- Progress Stepper -->
            <div class="flex justify-between mb-16 relative px-4">
                <div class="absolute top-1/2 left-0 w-full h-0.5 bg-white/5 -translate-y-1/2 z-0"></div>
                <div class="absolute top-1/2 left-0 h-0.5 bg-accent transition-all duration-700 ease-in-out -translate-y-1/2 z-0" :style="'width: ' + ((step-1)*20) + '%'"></div>
                
                <template x-for="i in 6">
                    <div class="relative z-10 flex flex-col items-center">
                        <div class="w-12 h-12 rounded-2xl flex items-center justify-center border-2 transition-all duration-500 transform" 
                             :class="step >= i ? 'bg-accent border-accent text-primary rotate-45' : 'bg-primary border-white/10 text-text-muted'"
                             @click="if(i < step) step = i">
                            <span class="transform -rotate-45 font-black" x-text="i"></span>
                        </div>
                        <span class="absolute -bottom-8 text-[9px] font-black uppercase tracking-widest text-text-muted" 
                              x-text="['Loan','Personal','Residence','Employment','Vehicle','Final'][i-1]"></span>
                    </div>
                </template>
            </div>

            <!-- STEP 1: Loan Information -->
            <div x-show="step === 1" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> Primary Borrower Information: <br><span class="text-sm font-bold text-text-muted ml-0 block mt-2">Loan Information</span>
                </h2>
                <div class="grid md:grid-cols-2 gap-8">
                    <div class="space-y-4">
                        <label class="block text-xs font-black text-gray-400 uppercase tracking-[0.2em]">Desired Loan Amount*</label>
                        <input type="text" name="desired_loan_amount" placeholder="$0.00" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-5 outline-none focus:border-accent focus:bg-accent/5 transition-all text-white">
                    </div>
                    <div class="space-y-4">
                        <label class="block text-xs font-black text-gray-400 uppercase tracking-[0.2em]">Desired Monthly Payment</label>
                        <input type="text" name="desired_monthly_payment" placeholder="$0.00" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-5 outline-none focus:border-accent focus:bg-accent/5 transition-all text-white">
                    </div>
                    <div class="space-y-4 md:col-span-2">
                        <label class="block text-xs font-black text-gray-400 uppercase tracking-[0.2em]">Which car are you applying for?</label>
                        <div class="relative group">
                            <i class="fas fa-car absolute left-6 top-1/2 -translate-y-1/2 text-accent/50"></i>
                            <select name="selected_vehicle" class="w-full bg-white/5 border border-white/10 rounded-2xl pl-14 pr-6 py-5 outline-none focus:border-accent focus:bg-accent/5 appearance-none text-white transition-all">
                                <option value="" class="bg-primary">Select a vehicle from our inventory</option>
                                <option class="bg-primary">1991 Honda NSX</option>
                                <option class="bg-primary">1967 VW Beetle Custom</option>
                                <option class="bg-primary">1990 Porsche 911 (964)</option>
                                <option class="bg-primary">Other / General Approval</option>
                            </select>
                        </div>
                    </div>
                    <div class="space-y-4">
                        <label class="block text-xs font-black text-gray-400 uppercase tracking-[0.2em]">Down Payment</label>
                        <input type="text" name="down_payment" placeholder="$0.00" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-5 outline-none focus:border-accent focus:bg-accent/5 transition-all text-white">
                    </div>
                    <input type="hidden" name="application_type" value="car_sale">
                </div>
            </div>

            <!-- STEP 2: Personal Information -->
            <div x-show="step === 2" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> Personal Information
                </h2>
                <div class="grid md:grid-cols-2 gap-x-8 gap-y-6">
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">First Name*</label><input type="text" name="first_name" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Last Name*</label><input type="text" name="last_name" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="md:col-span-2 space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Address*</label><input type="text" name="address" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Landmark</label><input type="text" name="landmark" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">City*</label><input type="text" name="city" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">State / Province / Region*</label><input type="text" name="state" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">ZIP / Postal Code*</label><input type="text" name="zip_code" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Country*</label><input type="text" name="country" value="USA" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Daytime Phone*</label><input type="tel" name="daytime_phone" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Evening Phone</label><input type="tel" name="evening_phone" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Fax</label><input type="tel" name="fax" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Email*</label><input type="email" name="email" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white" required></div>
                </div>
            </div>

            <!-- STEP 3: SSN & Residence -->
            <div x-show="step === 3" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> SSN & Residence
                </h2>
                <div class="grid md:grid-cols-2 gap-8">
                    <div class="space-y-2 md:col-span-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Social Security Number (9 Digits Required*)</label>
                        <input type="password" name="ssn" placeholder="XXX-XX-XXXX" class="w-full bg-white/10 border border-white/10 rounded-2xl px-6 py-5 outline-none focus:border-accent focus:bg-accent/5 transition-all text-white text-2xl tracking-[0.5em]" maxlength="11">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Date of Birth* (mm/dd/yyyy)</label>
                        <input type="date" name="date_of_birth" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Residence Type</label>
                        <select name="residence_type" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                            <option class="bg-primary">Own - Mortgage</option>
                            <option class="bg-primary">Rent</option>
                            <option class="bg-primary">Own - Free and Clear</option>
                            <option class="bg-primary">Living with Family</option>
                        </select>
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Mortgage/Rent Payment (per month)*</label>
                        <input type="text" name="mortgage_rent_payment" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Time at Residence (years)*</label>
                        <input type="number" name="time_at_residence_years" @input="needsPriorAddress = $el.value < 5" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                    </div>
                    <div class="md:col-span-2 space-y-4 pt-4 mt-4 border-t border-white/5" x-show="needsPriorAddress" x-transition>
                        <label class="text-[10px] font-black uppercase text-accent tracking-widest">Prior Address (Lived there less than 5 years)</label>
                        <textarea name="prior_address" class="w-full bg-white/5 border border-white/20 rounded-2xl px-6 py-4 outline-none focus:border-accent text-white" rows="2"></textarea>
                    </div>
                    <div class="md:col-span-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest block mb-4">Which accounts are in your name?</label>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <template x-for="item in ['Utilities', 'Savings', 'Checking', 'Phone']">
                                <label class="relative group cursor-pointer">
                                    <input type="checkbox" :name="'account_types[]'" :value="item" class="hidden peer">
                                    <div class="bg-white/5 border border-white/10 rounded-2xl py-4 px-2 text-center transition-all peer-checked:bg-accent peer-checked:text-primary peer-checked:border-accent group-hover:bg-white/10">
                                        <span class="text-xs font-black uppercase tracking-widest" x-text="item"></span>
                                    </div>
                                </label>
                            </template>
                        </div>
                    </div>
                    <div class="md:col-span-2 grid md:grid-cols-3 gap-6 pt-6 border-t border-white/5 mt-4">
                        <div class="space-y-2"><label class="text-[9px] font-black uppercase text-text-muted">Drivers Lic. #*</label><input type="text" name="drivers_license_number" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                        <div class="space-y-2"><label class="text-[9px] font-black uppercase text-text-muted">Drivers Lic. State*</label><input type="text" name="drivers_license_state" placeholder="CA, NY, etc." class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                        <div class="space-y-2"><label class="text-[9px] font-black uppercase text-text-muted">Exp. Date* (mm/dd/yyyy)</label><input type="date" name="drivers_license_expiry" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                    </div>
                </div>
            </div>

            <!-- STEP 4: Employment Information -->
            <div x-show="step === 4" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> Employment Information
                </h2>
                <div class="grid md:grid-cols-2 gap-x-8 gap-y-6">
                    <div class="md:col-span-2 space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Employer Name*</label><input type="text" name="employer_name" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="md:col-span-2 space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Employer Address*</label><input type="text" name="employer_address" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">City*</label><input type="text" name="employer_city" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">State / Province / Region*</label><input type="text" name="employer_state" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">ZIP / Postal Code*</label><input type="text" name="employer_zip" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Country*</label><input type="text" name="employer_country" value="USA" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Business Phone*</label><input type="tel" name="business_phone" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Employment Status*</label>
                        <select name="employment_status" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                            <option class="bg-primary">Full Time</option>
                            <option class="bg-primary">Part Time</option>
                            <option class="bg-primary">Self Employed</option>
                            <option class="bg-primary">Military</option>
                            <option class="bg-primary">Retired</option>
                        </select>
                    </div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Occupation*</label><input type="text" name="occupation" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Time On Job (years)*</label><input type="number" name="time_on_job_years" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">How often are you paid*</label>
                        <select name="pay_frequency" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white">
                            <option class="bg-primary">Weekly</option>
                            <option class="bg-primary">Bi-Weekly</option>
                            <option class="bg-primary">Semi-Monthly</option>
                            <option class="bg-primary">Monthly</option>
                        </select>
                    </div>
                    <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">How much per paycheck (numbers only)*</label><input type="text" name="paycheck_amount" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                    <div class="md:col-span-2 mt-4 space-y-4">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Type of Other Income? (Check all that apply)</label>
                        <div class="flex flex-wrap gap-4">
                            <template x-for="type in ['W2', '1099', 'Checking', 'Alimony', 'Child support', 'SSI', 'Cash/Job Letter']">
                                <label class="cursor-pointer group flex items-center space-x-3 bg-white/5 rounded-2xl py-3 px-5 border border-white/10 hover:border-accent transition-all">
                                    <input type="checkbox" :name="'other_income_types[]'" :value="type" class="peer hidden">
                                    <i class="fas fa-check-circle text-accent opacity-0 peer-checked:opacity-100 transition-all"></i>
                                    <span class="text-xs font-bold uppercase tracking-widest" x-text="type"></span>
                                </label>
                            </template>
                        </div>
                    </div>
                    <div class="md:col-span-2 space-y-2"><label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Other Income Detail</label><input type="text" name="other_income_detail" placeholder="Amount and source" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent transition-all text-white"></div>
                </div>
            </div>

            <!-- STEP 5: Vehicle & Trade-in -->
            <div x-show="step === 5" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> Vehicle & Trade-in Information
                </h2>
                <div class="space-y-12">
                    <div class="bg-white/5 p-8 rounded-[2.5rem] border border-white/10">
                        <h4 class="text-xs font-black uppercase tracking-[0.3em] text-accent mb-8">Desired Vehicle Details:</h4>
                        <div class="grid md:grid-cols-4 gap-6">
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Make</label><input type="text" name="vehicle_make" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Model</label><input type="text" name="vehicle_model" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Year</label><input type="text" name="vehicle_year" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Mileage</label><input type="text" name="vehicle_mileage" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                        </div>
                    </div>
                    <div class="bg-white/5 p-8 rounded-[2.5rem] border border-white/10">
                        <h4 class="text-xs font-black uppercase tracking-[0.3em] text-accent mb-8">Trade-In Details (Optional):</h4>
                        <div class="grid md:grid-cols-4 gap-6">
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Make</label><input type="text" name="tradein_make" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Model</label><input type="text" name="tradein_model" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Year</label><input type="text" name="tradein_year" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                            <div class="space-y-2"><label class="text-[10px] font-black uppercase text-text-muted">Mileage</label><input type="text" name="tradein_mileage" class="w-full bg-primary/50 border border-white/10 rounded-xl px-4 py-3 text-white outline-none focus:border-accent"></div>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-text-muted tracking-widest">Additional Comments</label>
                        <textarea name="additional_comments" class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 outline-none focus:border-accent text-white" rows="4"></textarea>
                    </div>
                </div>
            </div>

            <!-- STEP 6: Consent & Human Verification -->
            <div x-show="step === 6" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
                <h2 class="text-3xl font-black mb-10 flex items-center">
                    <span class="w-2 h-12 bg-accent mr-6"></span> Consent & Authorization
                </h2>
                <div class="space-y-10">
                    <div class="bg-white/5 border border-white/10 p-10 rounded-[2.5rem] relative">
                        <div class="absolute -top-4 left-10 bg-accent text-primary px-6 py-1 rounded-full text-[10px] font-black uppercase tracking-widest">Legal Binding</div>
                        <div class="space-y-6 text-xs text-gray-400 leading-relaxed max-h-60 overflow-y-auto pr-4 scrollbar-custom">
                            <p class="font-bold text-white uppercase mb-4 tracking-wider">I authorize Ultimate Auto Care and its partners to:</p>
                            <p>1. Obtain my credit report from any reporting agency (Experian, TransUnion, Equifax) for the purpose of pre-qualification and loan evaluation.</p>
                            <p>2. Share this application and the resulting credit info with authorized financial institutions engaged as service providers by this dealer.</p>
                            <p>3. Verify all information provided herein, including employment and salary history.</p>
                            <p class="italic">By submitting this application, I certify that all information herein is true and complete. I acknowledge that my information may be shared pursuant to the dealer's privacy policy.</p>
                        </div>
                        <label class="flex items-center space-x-6 cursor-pointer group mt-10 pt-8 border-t border-white/5">
                            <input type="checkbox" name="consent_given" id="consent_given" value="1" class="hidden peer" required>
                            <div class="w-10 h-10 border-2 border-white/20 rounded-xl flex items-center justify-center peer-checked:bg-accent peer-checked:border-accent peer-checked:text-primary transition-all rotate-12 peer-checked:rotate-0">
                                <i class="fas fa-signature"></i>
                            </div>
                            <span class="text-sm font-black uppercase tracking-widest group-hover:text-accent transition-colors">I accept the terms and authorize the investigation</span>
                        </label>
                    </div>

                    <!-- Human Verification -->
                    <div class="text-center bg-white/5 border border-white/10 rounded-[2.5rem] p-10">
                        <p class="text-xs font-black uppercase tracking-[0.3em] text-text-muted mb-8">Please prove you are human by selecting the <span class="text-accent underline">Star</span></p>
                        <div class="flex justify-center flex-wrap gap-8">
                            <template x-for="icon in ['cloud', 'moon', 'star', 'sun', 'umbrella']">
                                <button type="button" 
                                        @click="humanVerified = (icon === 'star')"
                                        class="w-20 h-20 bg-primary border-2 border-white/5 rounded-3xl flex items-center justify-center text-3xl transition-all transform hover:scale-110 active:scale-95"
                                        :class="humanVerified && icon === 'star' ? 'bg-accent/20 border-accent text-accent shadow-[0_0_30px_rgba(250,204,21,0.2)]' : 'text-white/20 hover:border-white/20'">
                                    <i :class="'fas fa-' + icon"></i>
                                </button>
                            </template>
                        </div>
                    </div>

                    <button type="submit" :disabled="!humanVerified || submitting" 
                            @click.prevent="if(humanVerified && !submitting) { submitting = true; submitFinancingForm() }"
                            class="w-full bg-accent hover:bg-accent-dark text-primary py-8 rounded-[2rem] font-black text-2xl uppercase tracking-[0.2em] transition-all transform hover:scale-[1.02] shadow-[0_20px_40px_rgba(250,204,21,0.2)] disabled:opacity-20 disabled:grayscale disabled:cursor-not-allowed">
                        <span x-show="!submitting">Finalize & Submit</span>
                        <span x-show="submitting"><i class="fas fa-spinner fa-spin mr-3"></i>Submitting...</span>
                    </button>
                </div>
            </div>

            <!-- Global Footer Buttons -->
            <div class="flex justify-between items-center mt-12 pt-10 border-t border-white/5">
                <button type="button" x-show="step > 1" @click="prevStep()" class="flex items-center space-x-4 text-xs font-black uppercase tracking-widest text-text-muted hover:text-white transition-colors">
                    <i class="fas fa-arrow-left"></i> <span>Previous Section</span>
                </button>
                <div class="flex-1 text-center">
                    <span class="text-[10px] font-black text-text-muted uppercase tracking-[0.4em]" x-text="'PAGE ' + step + ' OF 6'"></span>
                </div>
                <button type="button" x-show="step < 6" @click="nextStep()" class="group flex items-center space-x-4 bg-white/5 border border-white/10 px-10 py-5 rounded-2xl text-xs font-black uppercase tracking-widest hover:border-accent hover:bg-accent hover:text-primary transition-all">
                    <span>Next Section</span> <i class="fas fa-arrow-right group-hover:translate-x-2 transition-transform"></i>
                </button>
            </div>
        </form>
    </div>
</main>

<style>
    input::placeholder { color: rgba(255,255,255,0.1); }
    input[type="date"]::-webkit-calendar-picker-indicator {
        filter: invert(1) brightness(2);
        cursor: pointer;
    }
    .scrollbar-custom::-webkit-scrollbar { width: 4px; }
    .scrollbar-custom::-webkit-scrollbar-track { background: transparent; }
    .scrollbar-custom::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.1); border-radius: 10px; }
</style>

<script>
function submitFinancingForm() {
    const form = document.getElementById('financing-form');
    const formData = new FormData(form);
    const data = {};
    
    formData.forEach((value, key) => {
        if (key.endsWith('[]')) {
            const cleanKey = key.slice(0, -2);
            if (!data[cleanKey]) data[cleanKey] = [];
            data[cleanKey].push(value);
        } else {
            data[key] = value;
        }
    });

    // Handle consent checkbox
    data['consent_given'] = document.getElementById('consent_given').checked ? '1' : '0';

    fetch('handler.php?action=financing', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
        },
        body: JSON.stringify(data)
    })
    .then(res => res.json())
    .then(result => {
        if (result.success) {
            document.getElementById('financing-form').style.display = 'none';
            const successEl = document.getElementById('form-success');
            successEl.classList.remove('hidden');
            document.getElementById('success-message').textContent = result.message;
            window.scrollTo({ top: 0, behavior: 'smooth' });
        } else {
            const errorEl = document.getElementById('form-error');
            errorEl.classList.remove('hidden');
            let errors = '';
            if (result.errors) {
                Object.values(result.errors).forEach(e => errors += '<p>• ' + e[0] + '</p>');
            } else {
                errors = result.message || 'Submission failed. Please try again.';
            }
            errorEl.innerHTML = errors;
            // Reset submitting state in Alpine
            document.querySelector('[x-data]').__x.$data.submitting = false;
        }
    })
    .catch(err => {
        console.error(err);
        document.getElementById('form-error').classList.remove('hidden');
        document.getElementById('form-error').textContent = 'Connection error. Please ensure the backend server is running.';
        document.querySelector('[x-data]').__x.$data.submitting = false;
    });
}
</script>

<?php include 'includes/footer.php'; ?>



