<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'services.php');

// Fetch active services
$query = "SELECT * FROM services WHERE is_active = 1 ORDER BY id DESC";
$res_services = $conn->query($query);
?>

<main class="pt-52 pb-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="text-center mb-20" 
             x-data="{ 
                loaded: false,
                content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
                init() {
                    setTimeout(() => this.loaded = true, 100);
                }
             }">
            <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 translateY(20px)" x-transition:enter-end="opacity-100 translateY(0)">
                <h1 class="text-5xl md:text-6xl font-black mb-6"
                    x-html="content.page_title ? content.page_title.replace('Service', '<span class=\'text-gradient\'>Service</span>') : 'Our <span class=\'text-gradient\'>Service</span> Catalog'">
                    Our <span class="text-gradient">Service</span> Catalog
                </h1>
                <p class="text-text-muted text-xl max-w-2xl mx-auto"
                   x-text="content.page_description || 'From routine maintenance to complex mechanical overhauls, we provide premium care for every vehicle.'">
                    From routine maintenance to complex mechanical overhauls, we provide premium care for every vehicle.
                </p>
            </div>
        </div>

        <!-- Services Grid -->
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php while ($service = $res_services->fetch()): ?>
                <div class="glass-card p-10 rounded-[2.5rem] group hover:bg-white/5 transition-all">
                    <div class="w-20 h-20 bg-accent/10 rounded-3xl flex items-center justify-center text-accent mb-8 group-hover:scale-110 group-hover:bg-accent group-hover:text-primary transition-all duration-500 shadow-xl shadow-accent/5">
                        <i class="fas <?php echo htmlspecialchars($service['icon'] ?: 'fa-wrench'); ?> text-4xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4"><?php echo htmlspecialchars($service['title']); ?></h3>
                    <p class="text-text-muted mb-8 leading-relaxed line-clamp-3">
                        <?php echo htmlspecialchars($service['description']); ?>
                    </p>
                    <div class="flex items-center justify-between pt-6 border-t border-white/5">
                        <a href="service-detail.php?id=<?php echo $service['slug']; ?>" class="text-accent font-bold hover:underline">View Details</a>
                        <a href="contact.php?service=<?php echo $service['slug']; ?>" class="bg-white/5 hover:bg-accent hover:text-primary px-6 py-2 rounded-xl text-sm font-bold transition-all">Book Now</a>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </div>

    <!-- Stats Section -->
    <section class="mt-32 py-20 bg-secondary/20" x-data="{ content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?> }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-2 lg:grid-cols-4 gap-12 text-center">
                <div>
                    <h4 class="text-5xl font-black text-accent mb-2" x-text="content.stats1_value || '98%'">98%</h4>
                    <p class="text-text-muted uppercase tracking-widest font-bold text-xs" x-text="content.stats1_label || 'Customer Satisfaction'">Customer Satisfaction</p>
                </div>
                <div>
                    <h4 class="text-5xl font-black text-accent mb-2" x-text="content.stats2_value || '10k+'">10k+</h4>
                    <p class="text-text-muted uppercase tracking-widest font-bold text-xs" x-text="content.stats2_label || 'Cars Serviced'">Cars Serviced</p>
                </div>
                <div>
                    <h4 class="text-5xl font-black text-accent mb-2" x-text="content.stats3_value || '24/7'">24/7</h4>
                    <p class="text-text-muted uppercase tracking-widest font-bold text-xs" x-text="content.stats3_label || 'Emergency Support'">Emergency Support</p>
                </div>
                <div>
                    <h4 class="text-5xl font-black text-accent mb-2" x-text="content.stats4_value || '12mo'">12mo</h4>
                    <p class="text-text-muted uppercase tracking-widest font-bold text-xs" x-text="content.stats4_label || 'Service Warranty'">Service Warranty</p>
                </div>
            </div>
        </div>
    </section>
</main>

<?php include 'includes/footer.php'; ?>
