<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'index.php');

// Fetch featured cars
$featured_query = "SELECT * FROM cars WHERE is_featured = 1 AND status = 'available' LIMIT 3";
$featured_stmt = $conn->query($featured_query);
$featuredCars = [];
while ($row = $featured_stmt->fetch()) {
    $row['image'] = sanitizeImageUrl($row['image']);
    $featuredCars[] = $row;
}

// Fetch 3 active services
$services_query = "SELECT * FROM services WHERE is_active = 1 ORDER BY id DESC LIMIT 3";
$services_stmt = $conn->query($services_query);
$allServices = $services_stmt->fetchAll();
?>

<main x-data="{ 
    content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
    featuredCars: <?php echo htmlspecialchars(json_encode($featuredCars), ENT_QUOTES, 'UTF-8'); ?>,
    allServices: <?php echo htmlspecialchars(json_encode($allServices), ENT_QUOTES, 'UTF-8'); ?>
}">
    <!-- Hero Section -->
    <section class="relative min-h-screen flex items-center pt-48 overflow-hidden">
        <div class="hero-glow top-0 -left-20"></div>
        <div class="hero-glow bottom-0 -right-20"></div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                <div class="space-y-8" x-data="{ loaded: false }" x-init="setTimeout(() => loaded = true, 100)">
                    <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 -translate-x-12" x-transition:enter-end="opacity-100 translate-x-0">
                        <span class="inline-block glass px-4 py-1.5 rounded-full text-accent text-sm font-bold tracking-wider mb-4 border border-accent/20"
                              x-text="content.hero_badge || 'CERTIFIED CAR SPECIALISTS'">
                            CERTIFIED CAR SPECIALISTS
                        </span>
                        <h1 class="text-5xl md:text-6xl font-extrabold leading-tight mb-6"
                            x-html="content.hero_title || 'Auto Repair & <span class=\'text-gradient\'>Used Car Sales</span> in North Lauderdale, Florida'">
                            Auto Repair & <span class="text-gradient">Used Car Sales</span> in North Lauderdale, Florida
                        </h1>
                        <p class="text-text-muted text-lg max-w-lg mb-10 leading-relaxed"
                           x-text="content.hero_description || 'Our ASE certified technicians have over 20 years of full service automotive experience on Japanese, European and American vehicles.'">
                            Our ASE certified technicians have over 20 years of full service automotive experience on Japanese, European and American vehicles.
                        </p>
                        <div class="flex flex-wrap items-center gap-4">
                            <a href="contact.php" class="bg-accent hover:bg-accent-dark text-primary px-6 py-3 rounded-xl font-bold text-base transition-all transform hover:scale-105 shadow-lg shadow-accent/20">
                                Book Appointment
                            </a>
                            <a href="cars.php" class="glass px-6 py-3 rounded-xl font-bold text-base hover:bg-white/10 transition-all border border-white/10">
                                Browse Used Cars
                            </a>
                        </div>
                    </div>
                </div>

                <div class="relative hidden lg:block" x-data="{ loaded: false }" x-init="setTimeout(() => loaded = true, 300)">
                    <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 translate-x-12" x-transition:enter-end="opacity-100 translate-x-0"
                         class="relative z-10">
                        <img src="https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?q=80&w=2072&auto=format&fit=crop" 
                             alt="Luxury Car Workshop" 
                             class="rounded-3xl shadow-2xl border border-white/5 animate-float">
                        
                        <!-- Floating Stats -->
                        <div class="absolute -bottom-6 -left-6 glass p-6 rounded-2xl border border-white/10 animate-bounce transition-all hover:scale-110 cursor-default" style="animation-duration: 4s;">
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 bg-accent/20 rounded-full flex items-center justify-center text-accent">
                                    <i class="fas fa-check-circle text-2xl"></i>
                                </div>
                                <div>
                                    <p class="text-2xl font-bold" x-text="content.stat1_value || '20+'">20+</p>
                                    <p class="text-xs text-text-muted font-bold uppercase tracking-widest" x-text="content.stat1_label || 'Years Exp'">Years Exp</p>
                                </div>
                            </div>
                        </div>

                        <div class="absolute -top-6 -right-6 glass p-6 rounded-2xl border border-white/10 animate-pulse transition-all hover:scale-110 cursor-default" style="animation-duration: 3s;">
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 bg-green-500/20 rounded-full flex items-center justify-center text-green-400">
                                    <i class="fas fa-award text-2xl"></i>
                                </div>
                                <div>
                                    <p class="text-2xl font-bold" x-text="content.stat2_value || '5k+'">5k+</p>
                                    <p class="text-xs text-text-muted font-bold uppercase tracking-widest" x-text="content.stat2_label || 'Happy Clients'">Happy Clients</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Services Section -->
    <section class="py-24 bg-secondary/30 relative">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mb-16">
            <div class="text-center">
                <h2 class="text-4xl md:text-5xl font-bold mb-4" x-html="content.services_title ? content.services_title.replace('Services', '<span class=\'text-accent\'>Services</span>') : 'Our Elite <span class=\'text-accent\'>Services</span>'">Our Elite <span class="text-accent">Services</span></h2>
                <p class="text-text-muted max-w-2xl mx-auto" x-text="content.services_description || 'Expert mechanical solutions tailored to your vehicle\'s specific needs using state-of-the-art diagnostic equipment.'">Expert mechanical solutions tailored to your vehicle's specific needs using state-of-the-art diagnostic equipment.</p>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-3 gap-8">
                <template x-for="service in allServices" :key="service.id">
                    <div class="glass-card p-8 rounded-3xl h-full border border-white/5 hover:border-accent/30 transition-all duration-500 bg-white/5 group">
                        <div class="w-16 h-16 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-6 group-hover:bg-accent group-hover:text-primary transition-all duration-500">
                            <i :class="'fas ' + (service.icon || 'fa-wrench') + ' text-3xl'"></i>
                        </div>
                        <h3 class="text-2xl font-bold mb-4" x-text="service.title"></h3>
                        <p class="text-text-muted mb-6 leading-relaxed line-clamp-2 text-sm" x-text="service.description"></p>
                        <div class="flex items-center justify-between mt-auto pt-4 border-t border-white/5">
                            <a :href="'service-detail.php?id=' + service.slug" class="text-accent font-bold flex items-center space-x-2 hover:translate-x-2 transition-transform">
                                <span>Read More</span>
                                <i class="fas fa-arrow-right text-sm"></i>
                            </a>
                            <a :href="'contact.php?service=' + service.slug" class="bg-white/5 hover:bg-accent hover:text-primary px-4 py-2 rounded-xl text-xs font-bold transition-all">Book Now</a>
                        </div>
                    </div>
                </template>
            </div>
        </div>

        <div class="mt-16 text-center">
            <a href="services.php" class="inline-flex items-center space-x-3 text-lg font-bold border-b-2 border-accent pb-1 hover:text-accent transition-colors">
                <span>View All Services</span>
                <i class="fas fa-chevron-right"></i>
            </a>
        </div>
    </section>

    <!-- Cars for Sale Section -->
    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex flex-col md:row justify-between items-end mb-16 space-y-4">
                <div>
                    <h2 class="text-4xl md:text-5xl font-bold mb-4" x-html="content.classics_title ? content.classics_title.replace('Classics', '<span class=\'text-accent\'>Classics</span>') : 'Restored <span class=\'text-accent\'>Classics</span>'">Restored <span class="text-accent">Classics</span></h2>
                    <p class="text-text-muted" x-text="content.classics_description || 'Discover our curated selection of hand-picked, fully restored vintage cars.'">Discover our curated selection of hand-picked, fully restored vintage cars.</p>
                </div>
                <a href="cars.php" class="bg-white/5 hover:bg-white/10 px-8 py-3 rounded-xl font-bold transition-all border border-white/10">
                    Browse Catalog
                </a>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <template x-for="car in featuredCars" :key="car.id">
                    <div class="glass-card rounded-3xl overflow-hidden group">
                        <div class="relative h-64 overflow-hidden">
                            <img :src="car.image" :alt="car.make + ' ' + car.model" 
                                 @error="$event.target.src='https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?q=80&w=2000'"
                                 class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700">
                            <div class="absolute inset-0 car-overlay flex items-end p-6">
                                <span class="bg-accent text-primary text-xs font-black px-3 py-1 rounded-full uppercase tracking-tighter" x-text="car.status === 'available' ? 'New Arrival' : 'Sold'"></span>
                            </div>
                        </div>
                        <div class="p-8">
                            <div class="flex justify-between items-start mb-4">
                                <div>
                                    <h3 class="text-2xl font-bold" x-text="'Used ' + car.make + ' ' + car.model"></h3>
                                    <p class="text-accent text-sm font-bold" x-text="car.year + ' | ' + car.type"></p>
                                </div>
                                <span class="text-2xl font-black text-white" x-text="'$' + parseInt(car.price).toLocaleString()"></span>
                            </div>
                            <p class="text-text-muted text-sm mb-6 line-clamp-2" x-text="car.description"></p>
                            <div class="flex space-x-4 text-xs font-bold text-text-muted mb-8">
                                <span class="bg-white/5 px-3 py-1.5 rounded-lg flex items-center"><i class="fas fa-tachometer-alt mr-2 text-accent"></i> <span x-text="car.mileage"></span></span>
                                <span class="bg-white/5 px-3 py-1.5 rounded-lg flex items-center"><i class="fas fa-cog mr-2 text-accent"></i> <span x-text="car.transmission"></span></span>
                            </div>
                            <a :href="'car-detail.php?id=' + car.id" class="block text-center bg-accent/10 hover:bg-accent text-accent hover:text-primary font-bold py-4 rounded-xl transition-all">
                                View Details
                            </a>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="py-24 relative overflow-hidden min-h-[600px] flex items-center">
        <!-- Background Image with Overlay -->
        <div class="absolute inset-0 z-0">
            <img src="https://www.myfng.co.in/blogs/uploads/file_689079463eeba3.97377767.webp" 
                 class="w-full h-full object-cover" alt="Workshop Background">
            <div class="absolute inset-0 bg-primary/80 backdrop-blur-[2px]"></div>
            <div class="absolute inset-0 bg-gradient-to-b from-primary via-transparent to-primary"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full">
            <div class="text-center mb-16">
                <span class="text-accent font-bold tracking-widest uppercase text-sm mb-4 block" x-text="content.testimonials_badge || 'TESTIMONIALS'">TESTIMONIALS</span>
                <h2 class="text-4xl md:text-5xl font-black mb-4 text-white" 
                    x-html="content.testimonials_title ? content.testimonials_title.replace('Stories', '<span class=\'text-accent\'>Stories</span>') : 'Client <span class=\'text-accent\'>Stories</span>'">
                    Client <span class="text-accent">Stories</span>
                </h2>
                <div class="flex justify-center space-x-1 text-accent mb-4">
                    <i class="fas fa-star text-sm"></i>
                    <i class="fas fa-star text-sm"></i>
                    <i class="fas fa-star text-sm"></i>
                    <i class="fas fa-star text-sm"></i>
                    <i class="fas fa-star text-sm"></i>
                </div>
            </div>

            <!-- Scrolling Container -->
            <div class="relative group">
                <div class="flex overflow-x-auto gap-8 pb-12 scrollbar-hide snap-x" id="testimonials-scroll">
                    <!-- Story 1 -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-accent/30 transition-all duration-500 shadow-2xl">
                            <i class="fas fa-quote-right absolute top-10 right-10 text-accent/10 text-7xl"></i>
                            <p class="text-xl italic mb-10 relative z-10 leading-relaxed text-gray-100" x-text="content.testimonial1_quote || 'The only place I trust with my 1974 Alpha Romeo. Their attention to detail on the engine restoration was absolutely incredible.'">
                                "The only place I trust with my 1974 Alpha Romeo. Their attention to detail on the engine restoration was absolutely incredible."
                            </p>
                            <div class="flex items-center space-x-4">
                                <div class="w-14 h-14 bg-accent rounded-2xl flex items-center justify-center font-bold text-primary transform rotate-6 hover:rotate-0 transition-transform" x-text="content.testimonial1_initials || 'JD'">JD</div>
                                <div>
                                    <p class="font-bold text-lg text-white" x-text="content.testimonial1_author || 'John Doe'">John Doe</p>
                                    <p class="text-xs text-accent uppercase tracking-widest font-bold" x-text="content.testimonial1_role || 'Collector'">Collector</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Story 2 -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-accent/30 transition-all duration-500 shadow-2xl">
                            <i class="fas fa-quote-right absolute top-10 right-10 text-accent/10 text-7xl"></i>
                            <p class="text-xl italic mb-10 relative z-10 leading-relaxed text-gray-100" x-text="content.testimonial2_quote || 'Fast, professionalized diagnostics. They fixed an AC issue that two other shops couldn\'t figure out. Highly recommended.'">
                                "Fast, professionalized diagnostics. They fixed an AC issue that two other shops couldn't figure out. Highly recommended."
                            </p>
                            <div class="flex items-center space-x-4">
                                <div class="w-14 h-14 bg-accent rounded-2xl flex items-center justify-center font-bold text-primary transform -rotate-6 hover:rotate-0 transition-transform" x-text="content.testimonial2_initials || 'SK'">SK</div>
                                <div>
                                    <p class="font-bold text-lg text-white" x-text="content.testimonial2_author || 'Sarah Knight'">Sarah Knight</p>
                                    <p class="text-xs text-accent uppercase tracking-widest font-bold" x-text="content.testimonial2_role || 'Tesla Owner'">Tesla Owner</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Story 3 -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-accent/30 transition-all duration-500 shadow-2xl">
                            <i class="fas fa-quote-right absolute top-10 right-10 text-accent/10 text-7xl"></i>
                            <p class="text-xl italic mb-10 relative z-10 leading-relaxed text-gray-100">
                                "Found my dream classic here. The buying process was transparent and the car was in even better shape than the photos."
                            </p>
                            <div class="flex items-center space-x-4">
                                <div class="w-14 h-14 bg-accent rounded-2xl flex items-center justify-center font-bold text-primary transform rotate-3 hover:rotate-0 transition-transform">MR</div>
                                <div>
                                    <p class="font-bold text-lg text-white">Marcus Reed</p>
                                    <p class="text-xs text-accent uppercase tracking-widest font-bold">Enthusiast</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Story 4 -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-accent/30 transition-all duration-500 shadow-2xl">
                            <i class="fas fa-quote-right absolute top-10 right-10 text-accent/10 text-7xl"></i>
                            <p class="text-xl italic mb-10 relative z-10 leading-relaxed text-gray-100">
                                "Incredible expertise in vintage electronics. They restored my dashboard clock to factory perfection."
                            </p>
                            <div class="flex items-center space-x-4">
                                <div class="w-14 h-14 bg-accent rounded-2xl flex items-center justify-center font-bold text-primary transform -rotate-3 hover:rotate-0 transition-transform">AW</div>
                                <div>
                                    <p class="font-bold text-lg text-white">Alex Wong</p>
                                    <p class="text-xs text-accent uppercase tracking-widest font-bold">Classic Owner</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Trustpilot Rating Card -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-[#00b67a]/30 transition-all duration-500 shadow-2xl flex flex-col justify-center items-center text-center">
                            <div class="mb-6">
                                <h3 class="text-3xl font-black text-[#00b67a]">Trustpilot</h3>
                            </div>
                            <div class="flex space-x-2 mb-6">
                                <div class="w-10 h-10 bg-[#00b67a] flex items-center justify-center rounded-sm text-white"><i class="fas fa-star text-sm"></i></div>
                                <div class="w-10 h-10 bg-[#00b67a] flex items-center justify-center rounded-sm text-white"><i class="fas fa-star text-sm"></i></div>
                                <div class="w-10 h-10 bg-[#00b67a] flex items-center justify-center rounded-sm text-white"><i class="fas fa-star text-sm"></i></div>
                                <div class="w-10 h-10 bg-[#00b67a] flex items-center justify-center rounded-sm text-white"><i class="fas fa-star text-sm"></i></div>
                                <div class="w-10 h-10 bg-white/10 flex items-center justify-center rounded-sm text-white/20"><i class="fas fa-star text-sm"></i></div>
                            </div>
                            <p class="text-xl font-bold text-white mb-2">4.0 / 5.0</p>
                            <p class="text-text-muted uppercase tracking-widest text-xs font-bold">Verified Reviews</p>
                        </div>
                    </div>

                    <!-- Google Rating Card -->
                    <div class="min-w-[350px] md:min-w-[450px] snap-center">
                        <div class="glass p-10 rounded-[2.5rem] relative h-full border border-white/10 hover:border-[#4285F4]/30 transition-all duration-500 shadow-2xl flex flex-col justify-center items-center text-center">
                            <div class="mb-6">
                                <h3 class="text-3xl font-black">
                                    <span class="text-[#4285F4]">G</span><span class="text-[#EA4335]">o</span><span class="text-[#FBBC05]">o</span><span class="text-[#4285F4]">g</span><span class="text-[#34A853]">l</span><span class="text-[#EA4335]">e</span>
                                </h3>
                            </div>
                            <div class="flex space-x-1 mb-6 text-yellow-400">
                                <i class="fas fa-star text-3xl"></i>
                                <i class="fas fa-star text-3xl"></i>
                                <i class="fas fa-star text-3xl"></i>
                                <i class="fas fa-star text-3xl"></i>
                                <i class="far fa-star text-3xl text-white/20"></i>
                            </div>
                            <p class="text-xl font-bold text-white mb-2">4.2 Rating</p>
                            <p class="text-text-muted uppercase tracking-widest text-xs font-bold">Customer Feedbacks</p>
                        </div>
                    </div>
                </div>

                <!-- Navigation Buttons -->
                <div class="hidden lg:flex absolute top-1/2 -translate-y-1/2 -left-8 -right-8 justify-between pointer-events-none">
                    <button onclick="document.getElementById('testimonials-scroll').scrollBy({left: -480, behavior: 'smooth'})" 
                            class="w-16 h-16 glass rounded-full flex items-center justify-center text-white pointer-events-auto hover:bg-accent hover:text-primary transition-all shadow-2xl border border-white/10">
                        <i class="fas fa-chevron-left text-xl"></i>
                    </button>
                    <button onclick="document.getElementById('testimonials-scroll').scrollBy({left: 480, behavior: 'smooth'})" 
                            class="w-16 h-16 glass rounded-full flex items-center justify-center text-white pointer-events-auto hover:bg-accent hover:text-primary transition-all shadow-2xl border border-white/10">
                        <i class="fas fa-chevron-right text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
    </section>

    <style>
    .scrollbar-hide::-webkit-scrollbar { display: none; }
    .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
    </style>

    <!-- Appointment Banner -->
    <section class="py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-gradient-to-r from-accent/20 to-indigo-500/20 rounded-[3rem] p-12 md:p-20 border border-white/5 text-center relative overflow-hidden group">
                <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')] opacity-10"></div>
                <div class="relative z-10">
                    <h2 class="text-4xl md:text-5xl font-black mb-6">Ready to Give Your Car the <br><span class="text-accent underline decoration-indigo-500">Elite Treatment?</span></h2>
                    <p class="text-xl text-text-muted mb-10 max-w-2xl mx-auto">Schedule your service today and experience premium automotive care.</p>
                    <a href="contact.php" class="bg-accent hover:bg-accent-dark text-primary px-12 py-5 rounded-2xl font-black text-xl transition-all inline-block shadow-2xl shadow-accent/40">
                        Book Your Slot Now
                    </a>
                </div>
            </div>
        </div>
    </section>
</main>

<?php include 'includes/footer.php'; ?>
