<?php include 'includes/header.php'; ?>

<main class="pt-52 pb-24">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8" 
         x-data="{ 
            content: {},
            async init() {
                const res = await api.get('/page-content?page=faq.php');
                if (res.success) {
                    this.content = res.data;
                }
            }
         }">
        <div class="text-center mb-16">
            <h1 class="text-5xl font-black mb-6" 
                x-html="content.page_title ? content.page_title.replace('Questions', '<span class=\'text-gradient\'>Questions</span>') : 'Frequently Asked <span class=\'text-gradient\'>Questions</span>'">
                Frequently Asked <span class="text-gradient">Questions</span>
            </h1>
            <p class="text-text-muted text-lg"
               x-text="content.page_subtitle || 'Everything you need to know about our services, restoration process, and pre-owned vehicle sales.'">
                Everything you need to know about our services, restoration process, and pre-owned vehicle sales.
            </p>
        </div>

        <div class="space-y-4" x-data="{ active: 1 }">
            <!-- FAQ 1 -->
            <div class="glass rounded-3xl overflow-hidden border border-white/5">
                <button @click="active = active === 1 ? null : 1" class="w-full flex items-center justify-between p-8 text-left focus:outline-none">
                    <span class="text-xl font-bold" :class="active === 1 ? 'text-accent' : 'text-white'">Do you provide warranties on car repairs?</span>
                    <i class="fas" :class="active === 1 ? 'fa-minus text-accent' : 'fa-plus text-text-muted'"></i>
                </button>
                <div x-show="active === 1" x-collapse class="px-8 pb-8 text-text-muted leading-relaxed">
                    Yes, we offer a 12-month or 12,000-mile warranty (whichever comes first) on all mechanical repairs and parts installed by our master technicians. Some performance parts may have specific manufacturer warranties.
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="glass rounded-3xl overflow-hidden border border-white/5">
                <button @click="active = active === 2 ? null : 2" class="w-full flex items-center justify-between p-8 text-left focus:outline-none">
                    <span class="text-xl font-bold" :class="active === 2 ? 'text-accent' : 'text-white'">Can you source specific vintage cars for collectors?</span>
                    <i class="fas" :class="active === 2 ? 'fa-minus text-accent' : 'fa-plus text-text-muted'"></i>
                </button>
                <div x-show="active === 2" x-collapse class="px-8 pb-8 text-text-muted leading-relaxed">
                    Absolutely. We have a global network of collectors and auction partners. If you're looking for a specific make, model, and year, we can handle the sourcing, inspection, and import process for you.
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="glass rounded-3xl overflow-hidden border border-white/5">
                <button @click="active = active === 3 ? null : 3" class="w-full flex items-center justify-between p-8 text-left focus:outline-none">
                    <span class="text-xl font-bold" :class="active === 3 ? 'text-accent' : 'text-white'">Do you service electric and hybrid vehicles?</span>
                    <i class="fas" :class="active === 3 ? 'fa-minus text-accent' : 'fa-plus text-text-muted'"></i>
                </button>
                <div x-show="active === 3" x-collapse class="px-8 pb-8 text-text-muted leading-relaxed">
                    Yes, our workshop is equipped with the latest diagnostic tools for modern EVs and Hybrids. Our technicians are Tesla-certified and trained in high-voltage system safety and maintenance.
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="glass rounded-3xl overflow-hidden border border-white/5">
                <button @click="active = active === 4 ? null : 4" class="w-full flex items-center justify-between p-8 text-left focus:outline-none">
                    <span class="text-xl font-bold" :class="active === 4 ? 'text-accent' : 'text-white'">How long does a typical full engine restoration take?</span>
                    <i class="fas" :class="active === 4 ? 'fa-minus text-accent' : 'fa-plus text-text-muted'"></i>
                </button>
                <div x-show="active === 4" x-collapse class="px-8 pb-8 text-text-muted leading-relaxed">
                    A full engine restoration can take anywhere from 4 to 12 weeks depending on the availability of parts (especially for rare classics) and the extent of the damage or wear. We provide weekly photo updates during the process.
                </div>
            </div>

            <!-- FAQ 5 -->
            <div class="glass rounded-3xl overflow-hidden border border-white/5">
                <button @click="active = active === 5 ? null : 5" class="w-full flex items-center justify-between p-8 text-left focus:outline-none">
                    <span class="text-xl font-bold" :class="active === 5 ? 'text-accent' : 'text-white'">Do you offer financing for car purchases?</span>
                    <i class="fas" :class="active === 5 ? 'fa-minus text-accent' : 'fa-plus text-text-muted'"></i>
                </button>
                <div x-show="active === 5" x-collapse class="px-8 pb-8 text-text-muted leading-relaxed">
                    Yes, we partner with specialized automotive lenders who understand the value of classic and collector cars. We can help you secure competitive financing rates for your purchase.
                </div>
            </div>
        </div>

        <!-- CTA -->
        <div class="mt-20 text-center">
            <p class="text-text-muted mb-6">Still have questions?</p>
            <a href="contact.php" class="bg-white/5 hover:bg-white/10 px-10 py-4 rounded-xl font-bold border border-white/10 transition-all inline-block">
                Contact Our Support Team
            </a>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>
