<?php 
include 'includes/header.php'; 
include 'config.php';

$content = getPageContent($conn, 'about.php');
?>

<main class="pt-52 pb-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Hero Section -->
        <div class="grid lg:grid-cols-2 gap-16 items-center mb-32" 
             x-data="{ 
                loaded: false,
                content: <?php echo htmlspecialchars(json_encode($content), ENT_QUOTES, 'UTF-8'); ?>,
                init() {
                    setTimeout(() => this.loaded = true, 100);
                }
             }">
            <div>
                <div x-show="loaded" x-transition:enter="transition ease-out duration-1000" x-transition:enter-start="opacity-0 -translate-x-12" x-transition:enter-end="opacity-100 translate-x-0">
                    <span class="text-accent font-bold tracking-widest uppercase text-sm mb-4 block" x-text="content.story_badge || 'OUR STORY'">OUR STORY</span>
                    <h1 class="text-5xl md:text-7xl font-black mb-8 leading-tight" 
                        x-html="content.about_title ? content.about_title.replace('Passion', '<span class=\'text-gradient\'>Passion</span>').replace('Precision', '<span class=\'text-gradient\'>Precision</span>') : 'Driven by <span class=\'text-gradient\'>Passion</span>, Defined by <span class=\'text-gradient\'>Precision</span>.'">
                        Driven by <span class="text-gradient">Passion</span>, Defined by <span class="text-gradient">Precision</span>.
                    </h1>
                    <p class="text-text-muted text-lg leading-relaxed mb-8"
                       x-text="content.about_description || 'Founded in 1998, AutoElite began as a small restoration shop for classic European sports cars. Over two decades, we\'ve evolved into a full-service automotive hub that bridges the gap between vintage craftsmanship and modern technology.'">
                        Founded in 1998, AutoElite began as a small restoration shop for classic European sports cars. Over two decades, we've evolved into a full-service automotive hub that bridges the gap between vintage craftsmanship and modern technology.
                    </p>
                    <div class="grid grid-cols-2 gap-8">
                        <div>
                            <h4 class="text-3xl font-black text-white mb-2" x-text="content.stat1_value || '25+'">25+</h4>
                            <p class="text-text-muted text-sm font-bold uppercase" x-text="content.stat1_label || 'Years of Excellence'">Years of Excellence</p>
                        </div>
                        <div>
                            <h4 class="text-3xl font-black text-white mb-2" x-text="content.stat2_value || '15'">15</h4>
                            <p class="text-text-muted text-sm font-bold uppercase" x-text="content.stat2_label || 'Master Technicians'">Master Technicians</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="relative">
                <img src="https://w0.peakpx.com/wallpaper/375/375/HD-wallpaper-car-workshop-digital-art-artist-artwork-artstation.jpg" 
                     alt="Classic Workshop" 
                     class="rounded-[3rem] shadow-2xl z-10 relative">
                <div class="absolute -bottom-10 -right-10 w-64 h-64 bg-accent/20 rounded-full blur-3xl -z-0"></div>
            </div>
        </div>

        <!-- Missions & Values -->
        <div class="grid md:grid-cols-3 gap-8 mb-32">
            <div class="glass p-10 rounded-[2.5rem] border-white/5">
                <div class="w-14 h-14 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-6">
                    <i class="fas fa-bullseye text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold mb-4" x-text="content.mission_title || 'Our Mission'">Our Mission</h3>
                <p class="text-text-muted leading-relaxed" x-text="content.mission_desc || 'To provide uncompromising automotive service that preserves the soul of every vehicle, whether it was built yesterday or fifty years ago.'">To provide uncompromising automotive service that preserves the soul of every vehicle, whether it was built yesterday or fifty years ago.</p>
            </div>
            <div class="glass p-10 rounded-[2.5rem] border-white/5">
                <div class="w-14 h-14 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-6">
                    <i class="fas fa-handshake text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold mb-4">Integrity</h3>
                <p class="text-text-muted leading-relaxed">No hidden costs, no unnecessary repairs. We believe in transparent communication and honest assessment of every car we touch.</p>
            </div>
            <div class="glass p-10 rounded-[2.5rem] border-white/5">
                <div class="w-14 h-14 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-6">
                    <i class="fas fa-award text-2xl"></i>
                </div>
                <h3 class="text-2xl font-bold mb-4">Excellence</h3>
                <p class="text-text-muted leading-relaxed">Continuous training and the latest diagnostic tools ensure we stay ahead of automotive evolution without losing vintage skills.</p>
            </div>
        </div>

        <!-- Performance Stats with Chart.js -->
        <div class="glass-card rounded-[3rem] p-12 md:p-20 mb-32">
            <div class="grid lg:grid-cols-2 gap-16 items-center">
                <div>
                    <h2 class="text-4xl font-black mb-6">A Legacy of <span class="text-accent">Growth</span></h2>
                    <p class="text-text-muted text-lg mb-8">Our commitment to quality has translated into a growing community of automotive enthusiasts who trust us with their most prized possessions.</p>
                    <ul class="space-y-6">
                        <li class="flex items-center space-x-4">
                            <div class="w-8 h-8 rounded-full bg-accent/20 flex items-center justify-center text-accent"><i class="fas fa-check"></i></div>
                            <span class="font-bold">ASE Certified Technicians</span>
                        </li>
                        <li class="flex items-center space-x-4">
                            <div class="w-8 h-8 rounded-full bg-accent/20 flex items-center justify-center text-accent"><i class="fas fa-check"></i></div>
                            <span class="font-bold">Authorized OEM Parts Dealer</span>
                        </li>
                        <li class="flex items-center space-x-4">
                            <div class="w-8 h-8 rounded-full bg-accent/20 flex items-center justify-center text-accent"><i class="fas fa-check"></i></div>
                            <span class="font-bold">Member of Classic Car Guild</span>
                        </li>
                    </ul>
                </div>
                <div class="bg-primary/50 p-6 rounded-3xl border border-white/5 shadow-inner">
                    <canvas id="growthChart" class="w-full h-64"></canvas>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('growthChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['2019', '2020', '2021', '2022', '2023', '2024'],
            datasets: [{
                label: 'Cars Serviced',
                data: [1200, 1500, 1800, 2400, 3100, 4200],
                borderColor: '#38bdf8',
                backgroundColor: 'rgba(56, 189, 248, 0.1)',
                fill: true,
                tension: 0.4,
                borderWidth: 3,
                pointRadius: 4,
                pointBackgroundColor: '#38bdf8'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(255, 255, 255, 0.05)' },
                    ticks: { color: '#94a3b8' }
                },
                x: {
                    grid: { display: false },
                    ticks: { color: '#94a3b8' }
                }
            }
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>
