@extends('layouts.main')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-12">
    <x-breadcrumb :items="['Services' => route('services.index'), $service->title => '']" />

    <div class="mt-12 grid lg:grid-cols-3 gap-16">
        <div class="lg:col-span-2 space-y-12">
            <header>
                <h1 class="text-6xl font-black italic mb-6 leading-tight">{{ $service->title }}</h1>
                <p class="text-xl text-slate-400 italic leading-relaxed">{{ $service->description }}</p>
            </header>

            <div class="rounded-[3rem] overflow-hidden border border-white/5 shadow-2xl relative group">
                <img src="{{ $service->featured_image }}" alt="{{ $service->image_alt }}" class="w-full h-[500px] object-cover transition-transform duration-700 group-hover:scale-105">
                <div class="absolute inset-0 bg-gradient-to-t from-primary/80 to-transparent opacity-60"></div>
            </div>

            @if($service->benefits && count($service->benefits) > 0)
            <section>
                <h2 class="text-3xl font-black mb-8 flex items-center">
                    <span class="w-12 h-1 bg-accent mr-4"></span> Key Benefits
                </h2>
                <div class="grid md:grid-cols-2 gap-6">
                    @foreach($service->benefits as $benefit)
                    <div class="glass p-6 rounded-2xl flex items-start space-x-4 border border-white/5 hover:border-accent/30 transition-all">
                        <i class="fas fa-check-circle text-accent mt-1"></i>
                        <span class="font-bold text-slate-200">{{ $benefit }}</span>
                    </div>
                    @endforeach
                </div>
            </section>
            @endif

            <div class="prose prose-invert prose-lg max-w-none">
                {!! $service->content !!}
            </div>

            @if($service->features && count($service->features) > 0)
            <section>
                <h2 class="text-3xl font-black mb-8 flex items-center">
                    <span class="w-12 h-1 bg-accent mr-4"></span> What's Included
                </h2>
                <div class="space-y-4">
                    @foreach($service->features as $feature)
                    <div class="glass px-8 py-5 rounded-2xl border border-white/5 flex items-center space-x-4">
                        <div class="w-2 h-2 rounded-full bg-accent shadow-[0_0_10px_#facc15]"></div>
                        <span class="text-slate-300 font-medium">{{ $feature }}</span>
                    </div>
                    @endforeach
                </div>
            </section>
            @endif
        </div>

        <div class="lg:col-span-1 space-y-8">
            {{-- Price Card --}}
            <div class="glass p-10 rounded-[3rem] border border-accent/20 text-center sticky top-24">
                <h3 class="text-slate-500 font-black uppercase tracking-widest text-xs mb-4">Estimated Price</h3>
                <div class="text-5xl font-black mb-8 text-gradient">{{ $service->price_starting_from ?: 'Quote Only' }}</div>
                
                <a href="{{ route('contact') }}?service={{ $service->slug }}" class="block w-full bg-accent hover:bg-accent-dark text-primary py-5 rounded-2xl font-black text-xl transition-all shadow-xl shadow-accent/20 transform hover:-translate-y-1">
                    Book This Service
                </a>
                <p class="text-[10px] text-slate-500 mt-6 italic">*Final price depends on vehicle inspection.</p>
                
                <div class="mt-10 pt-10 border-t border-white/5 text-left">
                    <h4 class="text-sm font-black text-white uppercase tracking-widest mb-4">Why choose us?</h4>
                    <ul class="space-y-3">
                        <li class="flex items-center space-x-3 text-xs text-slate-400">
                            <i class="fas fa-certificate text-accent"></i>
                            <span>Certified Master Mechanics</span>
                        </li>
                        <li class="flex items-center space-x-3 text-xs text-slate-400">
                            <i class="fas fa-shield-alt text-accent"></i>
                            <span>12-Month Service Warranty</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
