@php
    $settings = \App\Models\Setting::pluck('value', 'key');
    $schema = [
        "@context" => "https://schema.org",
        "@type" => "AutoRepair",
        "name" => $settings['business_name'] ?? 'Ultimate Auto Care',
        "address" => [
            "@type" => "PostalAddress",
            "streetAddress" => $settings['business_address'] ?? '',
        ],
        "telephone" => $settings['business_phone'] ?? '',
        "email" => $settings['business_email'] ?? '',
        "openingHours" => explode(',', $settings['business_opening_hours'] ?? ''),
        "url" => url('/'),
        "image" => asset('assets/images/logo.png')
    ];
@endphp

<script type="application/ld+json">
{!! json_encode($schema) !!}
</script>
