@extends('layouts.main')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-12">
    <x-breadcrumb :items="['Inventory' => route('cars.index'), $car->make . ' ' . $car->model => '']" />

    <div class="grid lg:grid-cols-2 gap-12 mt-12">
        <div class="space-y-6">
            <div class="rounded-[3rem] overflow-hidden border border-white/5 shadow-2xl">
                <img src="{{ $car->image }}" alt="{{ $car->image_alt ?? ($car->make . ' ' . $car->model) }}" class="w-full object-cover">
            </div>
            
            <div class="grid grid-cols-4 gap-4">
                {{-- Thumbnails would go here if multi-image --}}
            </div>
        </div>

        <div class="space-y-8 text-white">
            <div>
                <span class="inline-block bg-accent/20 text-accent px-4 py-1 rounded-full text-xs font-black uppercase tracking-widest mb-4">
                    {{ $car->type }}
                </span>
                <h1 class="text-5xl font-black mb-2">{{ $car->make }} {{ $car->model }}</h1>
                <p class="text-3xl text-gradient font-black">${{ number_format($car->price) }}</p>
            </div>

            <div class="glass p-8 rounded-3xl border border-white/5 grid grid-cols-2 gap-y-6 gap-x-12">
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Year</p>
                    <p class="font-bold">{{ $car->year }}</p>
                </div>
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Mileage</p>
                    <p class="font-bold">{{ $car->mileage }}</p>
                </div>
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Transmission</p>
                    <p class="font-bold">{{ $car->transmission }}</p>
                </div>
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Engine</p>
                    <p class="font-bold">{{ $car->engine }}</p>
                </div>
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Exterior Color</p>
                    <p class="font-bold">{{ $car->ext_color }}</p>
                </div>
                <div>
                    <p class="text-[10px] text-slate-500 uppercase tracking-widest font-black mb-1">Drive Type</p>
                    <p class="font-bold">{{ $car->drive_type }}</p>
                </div>
            </div>

            <div class="space-y-4">
                <h3 class="text-xl font-bold italic">Vehicle Description</h3>
                <p class="text-slate-400 leading-relaxed">{{ $car->description }}</p>
            </div>

            <div class="pt-8 border-t border-white/5 flex space-x-4">
                <a href="{{ route('contact') }}?car={{ $car->id }}" class="flex-1 bg-accent hover:bg-accent-dark text-primary py-5 rounded-2xl font-black text-center transition-all transform hover:scale-105">
                    Inquire About This Car
                </a>
                <button class="w-16 h-16 glass rounded-2xl flex items-center justify-center text-accent hover:bg-white/10 transition-all">
                    <i class="fas fa-heart"></i>
                </button>
            </div>
        </div>
    </div>
</div>
@endsection
