@extends('admin.layouts.app')
@section('title', 'SEO Master Manager')
@section('page-title', 'Search Engine Optimization')

@section('content')
<div class="max-w-7xl mx-auto space-y-8 pb-20">
    
    {{-- SEO Health Overview & Sitemap --}}
    <div class="grid lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 glass-strong rounded-[2.5rem] p-10 border border-white/5 shadow-2xl relative overflow-hidden">
            <div class="absolute top-0 right-0 p-8 opacity-10">
                <i class="fas fa-sitemap text-9xl"></i>
            </div>
            <h2 class="text-3xl font-black text-white mb-6">Sitemap Management</h2>
            <p class="text-slate-400 mb-8 max-w-lg">Your sitemap is automatically generated and synchronized with your content. You can submit these URLs to Google Search Console.</p>
            
            <div class="space-y-4 relative z-10">
                <div class="flex items-center justify-between p-4 bg-white/5 rounded-2xl border border-white/10">
                    <div class="flex items-center space-x-4">
                        <div class="w-10 h-10 bg-neon-cyan/20 rounded-xl flex items-center justify-center text-neon-cyan">
                            <i class="fas fa-link"></i>
                        </div>
                        <div>
                            <p class="text-sm font-bold text-white">Sitemap Index</p>
                            <p class="text-[10px] text-slate-500 font-mono">sitemap_index.xml</p>
                        </div>
                    </div>
                    <a href="{{ route('sitemap.index') }}" target="_blank" class="bg-neon-cyan text-primary px-4 py-2 rounded-lg text-xs font-black uppercase">View Index</a>
                </div>
                
                <div class="flex items-center justify-between p-4 bg-white/5 rounded-2xl border border-white/10">
                    <div class="flex items-center space-x-4">
                        <div class="w-10 h-10 bg-accent/20 rounded-xl flex items-center justify-center text-accent">
                            <i class="fas fa-list-ul"></i>
                        </div>
                        <div>
                            <p class="text-sm font-bold text-white">Main Content Sitemap</p>
                            <p class="text-[10px] text-slate-500 font-mono">sitemap.xml</p>
                        </div>
                    </div>
                    <a href="{{ route('sitemap') }}" target="_blank" class="bg-accent text-primary px-4 py-2 rounded-lg text-xs font-black uppercase">View Sitemap</a>
                </div>
            </div>
        </div>

        <div class="glass-strong rounded-[2.5rem] p-10 border border-white/5 shadow-2xl flex flex-col justify-between">
            <div>
                <h3 class="text-xl font-black text-white mb-2 italic">Search Console</h3>
                <p class="text-xs text-slate-500 mb-6">Submit your sitemap index at:</p>
                <div class="bg-black/40 p-4 rounded-xl border border-white/5 font-mono text-[10px] break-all text-accent">
                    https://www.theultimateautocare.com/sitemap_index.xml
                </div>
            </div>
            <div class="mt-8 pt-6 border-t border-white/5">
                <p class="text-[10px] font-black uppercase tracking-widest text-slate-500 mb-2">Google Indexing</p>
                <div class="flex items-center space-x-2">
                    <div class="w-2 h-2 rounded-full bg-neon-green"></div>
                    <span class="text-xs text-neon-green font-bold italic">Healthy & Reachable</span>
                </div>
            </div>
        </div>
    </div>

    {{-- SEO Management Tabs --}}
    <div x-data="{ tab: 'pages' }" class="space-y-6">
        <div class="flex space-x-4 p-2 bg-white/5 rounded-2xl w-max">
            <button @click="tab = 'pages'" :class="tab === 'pages' ? 'bg-accent text-white' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all">Static Pages</button>
            <button @click="tab = 'services'" :class="tab === 'services' ? 'bg-accent text-white' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all">Services</button>
            <button @click="tab = 'blogs'" :class="tab === 'blogs' ? 'bg-accent text-white' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all">Blog Posts</button>
            <button @click="tab = 'cars'" :class="tab === 'cars' ? 'bg-accent text-white' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all">Inventory</button>
            <button @click="tab = 'schema'" :class="tab === 'schema' ? 'bg-white/10 text-white' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all font-mono">#Schema</button>
            <button @click="tab = 'scripts'" :class="tab === 'scripts' ? 'bg-neon-green/20 text-neon-green' : 'text-slate-400 hover:text-white'" class="px-6 py-3 rounded-xl text-sm font-bold transition-all">Tracking</button>
        </div>

        {{-- Tracking Tab --}}
        <div x-show="tab === 'scripts'" class="glass-strong rounded-3xl p-8 border border-white/5 animate-in">
            <h2 class="text-2xl font-black text-white mb-6 flex items-center">
                <i class="fas fa-code text-neon-green mr-3"></i> Tracking & Integrations
            </h2>
            <form action="{{ route('admin.settings.seo.update') }}" method="POST" class="space-y-6">
                @csrf
                <div class="space-y-2">
                    <label class="text-xs font-bold text-slate-500 uppercase">Header Scripts (Google Analytics, Pixels)</label>
                    <textarea name="header_scripts" rows="6" class="w-full bg-black/50 border border-white/10 rounded-xl py-4 px-6 text-white font-mono text-xs focus:border-neon-green">{{ $settings['header_scripts'] ?? '' }}</textarea>
                    <p class="text-[10px] text-slate-500 italic">This code will be injected before the closing &lt;/head&gt; tag.</p>
                </div>
                <button type="submit" class="bg-neon-green text-primary px-8 py-4 rounded-xl font-black uppercase text-xs tracking-widest hover:scale-105 transition-all">Save Tracking Scripts</button>
            </form>
        </div>

        {{-- Schema Tab --}}
        <div x-show="tab === 'schema'" class="glass-strong rounded-3xl p-8 border border-white/5 animate-in">
            <h2 class="text-2xl font-black text-white mb-6 flex items-center">
                <i class="fas fa-store-alt text-neon-amber mr-3"></i> Local Business Schema (JSON-LD)
            </h2>
            <form action="{{ route('admin.settings.seo.update') }}" method="POST" class="space-y-6">
                @csrf
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label class="text-xs font-bold text-slate-500 uppercase">Business Name</label>
                        <input type="text" name="business_name" value="{{ $settings['business_name'] ?? '' }}" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 text-white focus:outline-none focus:border-neon-amber">
                    </div>
                    <div class="space-y-2">
                        <label class="text-xs font-bold text-slate-500 uppercase">Phone Number</label>
                        <input type="text" name="business_phone" value="{{ $settings['business_phone'] ?? '' }}" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 text-white">
                    </div>
                </div>
                <button type="submit" class="bg-neon-amber text-primary px-8 py-4 rounded-xl font-black uppercase text-xs tracking-widest hover:scale-105 transition-all">Save Schema</button>
            </form>
        </div>

        {{-- Pages Tab --}}
        <div x-show="tab === 'pages'" class="space-y-4 animate-in">
            @foreach($pages as $page)
            <div class="glass p-6 rounded-2xl border border-white/5 flex items-center justify-between hover:border-accent/30 transition-all">
                <div class="flex items-center space-x-6">
                    <div class="w-12 h-12 bg-white/5 rounded-xl flex items-center justify-center text-slate-400">
                        <i class="fas fa-file"></i>
                    </div>
                    <div>
                        <p class="font-bold text-white">{{ $page->title }}</p>
                        <p class="text-xs text-slate-500 font-mono">/{{ $page->slug }}</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="text-right hidden md:block">
                        <p class="text-[10px] text-slate-500 uppercase font-black">Optimization</p>
                        <p class="text-xs {{ $page->meta_title ? 'text-neon-green' : 'text-neon-amber' }} font-bold italic">{{ $page->meta_title ? 'Fully Optimized' : 'Needs Meta Title' }}</p>
                    </div>
                    <a href="{{ route('admin.cms.edit', $page->page_name ?: $page->slug) }}" class="p-3 glass rounded-xl text-slate-400 hover:text-accent transition-colors">
                        <i class="fas fa-edit"></i>
                    </a>
                </div>
            </div>
            @endforeach
        </div>

        {{-- Services Tab --}}
        <div x-show="tab === 'services'" class="space-y-4 animate-in">
            @foreach($services as $service)
            <div class="glass p-6 rounded-2xl border border-white/5 flex items-center justify-between hover:border-neon-cyan/30 transition-all">
                <div class="flex items-center space-x-6">
                    <img src="{{ $service->featured_image ?? 'https://images.unsplash.com/photo-1581092160562-40aa08e78837?q=80&w=100&auto=format&fit=crop' }}" class="w-12 h-12 rounded-xl object-cover glass">
                    <div>
                        <p class="font-bold text-white">{{ $service->title }}</p>
                        <p class="text-xs text-slate-500 font-mono">/service/{{ $service->slug }}</p>
                    </div>
                </div>
                <a href="{{ route('admin.services.edit', $service) }}" class="p-3 glass rounded-xl text-slate-400 hover:text-neon-cyan transition-colors">
                    <i class="fas fa-edit"></i>
                </a>
            </div>
            @endforeach
        </div>

        {{-- Blogs Tab --}}
        <div x-show="tab === 'blogs'" class="space-y-4 animate-in">
            @foreach($blogs as $blog)
            <div class="glass p-6 rounded-2xl border border-white/5 flex items-center justify-between hover:border-neon-purple/30 transition-all">
                <div class="flex items-center space-x-6">
                    <img src="{{ $blog->featured_image ?? 'https://images.unsplash.com/photo-1499750310107-5fef28a66643?q=80&w=100&auto=format&fit=crop' }}" class="w-12 h-12 rounded-xl object-cover glass">
                    <div>
                        <p class="font-bold text-white line-clamp-1">{{ $blog->title }}</p>
                        <p class="text-xs text-slate-500 font-mono">/blog/{{ $blog->slug }}</p>
                    </div>
                </div>
                <a href="{{ route('admin.blogs.edit', $blog) }}" class="p-3 glass rounded-xl text-slate-400 hover:text-neon-purple transition-colors">
                    <i class="fas fa-edit"></i>
                </a>
            </div>
            @endforeach
        </div>

        {{-- Cars Tab --}}
        <div x-show="tab === 'cars'" class="space-y-4 animate-in">
            @foreach($cars as $car)
            <div class="glass p-4 rounded-2xl border border-white/5 flex items-center justify-between hover:border-neon-rose/30 transition-all">
                <div class="flex items-center space-x-4">
                    <img src="{{ $car->image }}" class="w-16 h-10 rounded-lg object-cover">
                    <div>
                        <p class="text-sm font-bold text-white">{{ $car->make }} {{ $car->model }}</p>
                        <p class="text-[10px] text-slate-500 font-mono">/car/{{ $car->slug }}</p>
                    </div>
                </div>
                <a href="{{ route('admin.cars.edit', $car) }}" class="p-2 glass rounded-lg text-slate-400 hover:text-neon-rose transition-colors">
                    <i class="fas fa-edit text-xs"></i>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection
