<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin') — Ultimate Auto Care</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700;900&family=Plus+Jakarta+Sans:wght@400;500;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { outfit: ['Outfit', 'sans-serif'], jakarta: ['Plus Jakarta Sans', 'sans-serif'] },
                    colors: {
                        dark: { 900: '#050810', 800: '#0a0f1e', 700: '#0f1629', 600: '#161e38' },
                        accent: { DEFAULT: '#6366f1', light: '#818cf8', dark: '#4f46e5' },
                        neon: { purple: '#a855f7', cyan: '#06b6d4', green: '#10b981', amber: '#f59e0b', rose: '#f43f5e' }
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'slide-in': 'slideIn 0.5s ease-out',
                        'glow': 'glow 2s ease-in-out infinite alternate',
                    },
                    keyframes: {
                        float: { '0%, 100%': { transform: 'translateY(0px)' }, '50%': { transform: 'translateY(-20px)' } },
                        slideIn: { '0%': { opacity: '0', transform: 'translateX(-20px)' }, '100%': { opacity: '1', transform: 'translateX(0)' } },
                        glow: { '0%': { boxShadow: '0 0 5px #6366f1, 0 0 10px #6366f1' }, '100%': { boxShadow: '0 0 20px #6366f1, 0 0 40px #6366f1, 0 0 60px #6366f1' } },
                    }
                }
            }
        }
    </script>
    <style>
        * { font-family: 'Outfit', sans-serif; }
        body { background: #050810; color: #e2e8f0; }
        .glass { background: rgba(255,255,255,0.03); backdrop-filter: blur(20px); border: 1px solid rgba(255,255,255,0.08); }
        .glass-strong { background: rgba(255,255,255,0.06); backdrop-filter: blur(30px); border: 1px solid rgba(255,255,255,0.12); }
        .sidebar-link { transition: all 0.3s ease; position: relative; overflow: hidden; }
        .sidebar-link::before { content: ''; position: absolute; left: 0; top: 0; height: 100%; width: 3px; background: linear-gradient(to bottom, #6366f1, #a855f7); transform: scaleY(0); transition: transform 0.3s ease; border-radius: 0 2px 2px 0; }
        .sidebar-link:hover::before, .sidebar-link.active::before { transform: scaleY(1); }
        .sidebar-link:hover, .sidebar-link.active { background: rgba(99, 102, 241, 0.1); color: #818cf8; }
        .stat-card { transition: all 0.4s ease; }
        .stat-card:hover { transform: translateY(-4px); }
        .gradient-text { background: linear-gradient(135deg, #6366f1, #a855f7, #06b6d4); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .neon-border { box-shadow: 0 0 0 1px rgba(99,102,241,0.3), 0 0 20px rgba(99,102,241,0.1); }
        ::-webkit-scrollbar { width: 6px; } ::-webkit-scrollbar-track { background: #0a0f1e; } ::-webkit-scrollbar-thumb { background: #6366f1; border-radius: 10px; }
        .badge-pending { background: rgba(245,158,11,0.15); color: #f59e0b; border: 1px solid rgba(245,158,11,0.3); }
        .badge-approved { background: rgba(16,185,129,0.15); color: #10b981; border: 1px solid rgba(16,185,129,0.3); }
        .badge-rejected { background: rgba(244,63,94,0.15); color: #f43f5e; border: 1px solid rgba(244,63,94,0.3); }
        .badge-reviewing { background: rgba(99,102,241,0.15); color: #818cf8; border: 1px solid rgba(99,102,241,0.3); }
        .badge-unread { background: rgba(6,182,212,0.15); color: #06b6d4; border: 1px solid rgba(6,182,212,0.3); }
        .badge-read { background: rgba(100,116,139,0.15); color: #94a3b8; border: 1px solid rgba(100,116,139,0.3); }
        .badge-replied { background: rgba(16,185,129,0.15); color: #10b981; border: 1px solid rgba(16,185,129,0.3); }
        .badge-confirmed { background: rgba(16,185,129,0.15); color: #10b981; border: 1px solid rgba(16,185,129,0.3); }
        .badge-completed { background: rgba(99,102,241,0.15); color: #818cf8; border: 1px solid rgba(99,102,241,0.3); }
        .badge-cancelled { background: rgba(244,63,94,0.15); color: #f43f5e; border: 1px solid rgba(244,63,94,0.3); }
        .animate-in { animation: slideIn 0.5s ease-out forwards; }
    </style>
</head>
<body class="min-h-screen" x-data="{ sidebarOpen: true, mobileMenu: false }">

<!-- Animated Background -->
<div class="fixed inset-0 -z-10 overflow-hidden pointer-events-none">
    <div class="absolute top-0 left-1/4 w-96 h-96 bg-accent/5 rounded-full blur-[120px] animate-float"></div>
    <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-neon-purple/5 rounded-full blur-[120px] animate-float" style="animation-delay: 3s;"></div>
    <div class="absolute top-1/2 left-1/2 w-64 h-64 bg-neon-cyan/3 rounded-full blur-[100px] animate-pulse-slow"></div>
</div>

<div class="flex h-screen overflow-hidden">
    <!-- Sidebar -->
    <aside class="glass-strong flex-shrink-0 transition-all duration-300 flex flex-col"
           :class="sidebarOpen ? 'w-64' : 'w-20'"
           style="border-right: 1px solid rgba(255,255,255,0.06);">
        
        <!-- Logo -->
        <div class="p-5 border-b border-white/5 flex items-center space-x-3">
            <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-accent to-neon-purple flex items-center justify-center flex-shrink-0 animate-glow">
                <i class="fas fa-car text-white text-sm"></i>
            </div>
            <div x-show="sidebarOpen" x-transition class="overflow-hidden">
                <p class="font-black text-sm gradient-text leading-tight">Ultimate Auto</p>
                <p class="text-[10px] text-slate-500 uppercase tracking-widest">Admin Portal</p>
            </div>
        </div>

        <!-- Nav -->
        <nav class="flex-1 p-3 space-y-1 overflow-y-auto">
            @php
                $navItems = [
                    ['route' => 'admin.dashboard', 'icon' => 'fa-chart-pie', 'label' => 'Dashboard'],
                    ['route' => 'admin.cars.index', 'icon' => 'fa-car', 'label' => 'Car Shop CRM'],
                    ['route' => 'admin.services.index', 'icon' => 'fa-tools', 'label' => 'Services Cms'],
                    ['route' => 'admin.blogs.index', 'icon' => 'fa-blog', 'label' => 'Blog Manager'],
                    ['route' => 'admin.cms.index', 'icon' => 'fa-edit', 'label' => 'Page Builder'],
                    ['route' => 'admin.financing.index', 'icon' => 'fa-file-invoice-dollar', 'label' => 'Financing Apps'],
                    ['route' => 'admin.messages.index', 'icon' => 'fa-envelope', 'label' => 'Messages'],
                    ['route' => 'admin.bookings.index', 'icon' => 'fa-calendar-check', 'label' => 'Bookings'],
                    ['route' => 'admin.settings.seo', 'icon' => 'fa-search', 'label' => 'SEO Settings'],
                    ['route' => 'admin.users.index', 'icon' => 'fa-users-cog', 'label' => 'User Management'],
                ];
            @endphp
            @foreach($navItems as $item)
            <a href="{{ route($item['route']) }}" 
               class="sidebar-link flex items-center space-x-3 px-3 py-3 rounded-xl text-slate-400 {{ request()->routeIs($item['route']) ? 'active' : '' }}">
                <i class="fas {{ $item['icon'] }} w-5 text-center flex-shrink-0"></i>
                <span x-show="sidebarOpen" x-transition class="text-sm font-semibold overflow-hidden whitespace-nowrap">{{ $item['label'] }}</span>
            </a>
            @endforeach
        </nav>

        <!-- User + Logout -->
        <div class="p-3 border-t border-white/5">
            <div class="flex items-center space-x-3 px-3 py-2 mb-2" x-show="sidebarOpen">
                <div class="w-8 h-8 rounded-lg bg-gradient-to-br from-neon-purple to-accent flex items-center justify-center text-xs font-black text-white flex-shrink-0">
                    {{ strtoupper(substr(auth('admin')->user()->name ?? 'A', 0, 1)) }}
                </div>
                <div class="overflow-hidden">
                    <p class="text-xs font-bold text-white truncate">{{ auth('admin')->user()->name ?? 'Admin' }}</p>
                    <p class="text-[10px] text-slate-500 truncate">{{ auth('admin')->user()->role ?? 'admin' }}</p>
                </div>
            </div>
            <form action="{{ route('admin.logout') }}" method="POST">
                @csrf
                <button type="submit" class="sidebar-link w-full flex items-center space-x-3 px-3 py-3 rounded-xl text-slate-400 hover:text-neon-rose">
                    <i class="fas fa-sign-out-alt w-5 text-center flex-shrink-0"></i>
                    <span x-show="sidebarOpen" x-transition class="text-sm font-semibold">Logout</span>
                </button>
            </form>
            <button @click="sidebarOpen = !sidebarOpen" class="sidebar-link w-full flex items-center justify-center px-3 py-2 rounded-xl text-slate-500 mt-1">
                <i class="fas" :class="sidebarOpen ? 'fa-chevron-left' : 'fa-chevron-right'"></i>
            </button>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col overflow-hidden">
        <!-- Top Bar -->
        <header class="glass-strong px-6 py-4 flex items-center justify-between border-b border-white/5">
            <div>
                <h1 class="text-xl font-black text-white">@yield('page-title', 'Dashboard')</h1>
                <p class="text-xs text-slate-500">@yield('page-subtitle', 'Welcome back, ' . (auth('admin')->user()->name ?? 'Admin'))</p>
            </div>
            <div class="flex items-center space-x-4">
                @if(isset($stats['unread_messages']) && $stats['unread_messages'] > 0)
                <a href="{{ route('admin.messages.index') }}" class="relative">
                    <div class="w-10 h-10 glass rounded-xl flex items-center justify-center text-slate-400 hover:text-accent transition-colors">
                        <i class="fas fa-bell"></i>
                    </div>
                    <span class="absolute -top-1 -right-1 w-5 h-5 bg-neon-rose rounded-full text-[10px] font-black text-white flex items-center justify-center">{{ $stats['unread_messages'] }}</span>
                </a>
                @endif
                <div class="text-right">
                    <p class="text-xs text-slate-500">{{ now()->format('D, M j Y') }}</p>
                    <p class="text-xs font-bold text-accent">{{ now()->format('g:i A') }}</p>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <main class="flex-1 overflow-y-auto p-6">
            @if(session('success'))
            <div class="mb-6 glass border border-neon-green/30 rounded-2xl px-6 py-4 flex items-center space-x-3 text-neon-green animate-in" x-data x-init="setTimeout(() => $el.remove(), 5000)">
                <i class="fas fa-check-circle"></i>
                <span class="font-semibold">{{ session('success') }}</span>
            </div>
            @endif
            @if(session('error'))
            <div class="mb-6 glass border border-neon-rose/30 rounded-2xl px-6 py-4 flex items-center space-x-3 text-neon-rose animate-in">
                <i class="fas fa-exclamation-circle"></i>
                <span class="font-semibold">{{ session('error') }}</span>
            </div>
            @endif
            @yield('content')
        </main>
    </div>
</div>

@stack('scripts')
</body>
</html>
