@extends('admin.layouts.app')
@section('title', 'Application #' . $application->id)
@section('page-title', 'Application #' . $application->id)
@section('page-subtitle', $application->full_name . ' — ' . ucfirst($application->application_type))

@section('content')
<div class="grid lg:grid-cols-3 gap-6">
    <!-- Main Details -->
    <div class="lg:col-span-2 space-y-6">
        @php
        $sections = [
            'Loan Information' => ['fa-hand-holding-usd', [
                'Desired Loan Amount' => '$' . number_format($application->desired_loan_amount ?? 0, 2),
                'Monthly Payment' => '$' . number_format($application->desired_monthly_payment ?? 0, 2),
                'Selected Vehicle' => $application->selected_vehicle ?? 'N/A',
                'Down Payment' => '$' . number_format($application->down_payment ?? 0, 2),
            ]],
            'Personal Information' => ['fa-user', [
                'Full Name' => $application->full_name,
                'Email' => $application->email,
                'Daytime Phone' => $application->daytime_phone,
                'Evening Phone' => $application->evening_phone ?? 'N/A',
                'Address' => $application->address . ', ' . $application->city . ', ' . $application->state . ' ' . $application->zip_code,
                'Country' => $application->country,
            ]],
            'Residence & Verification' => ['fa-home', [
                'DOB' => $application->date_of_birth ? \Carbon\Carbon::parse($application->date_of_birth)->format('M j, Y') : 'N/A',
                'SSN (Last 4)' => '***-**-' . ($application->ssn_last4 ?? '****'),
                'Residence Type' => $application->residence_type ?? 'N/A',
                'Mortgage/Rent' => '$' . number_format($application->mortgage_rent_payment ?? 0, 2) . '/mo',
                'Time at Residence' => ($application->time_at_residence_years ?? 'N/A') . ' years',
                'DL Number' => $application->drivers_license_number ?? 'N/A',
                'DL State' => $application->drivers_license_state ?? 'N/A',
                'DL Expiry' => $application->drivers_license_expiry ? \Carbon\Carbon::parse($application->drivers_license_expiry)->format('M j, Y') : 'N/A',
            ]],
            'Employment Information' => ['fa-briefcase', [
                'Employer' => $application->employer_name ?? 'N/A',
                'Status' => $application->employment_status ?? 'N/A',
                'Occupation' => $application->occupation ?? 'N/A',
                'Time on Job' => ($application->time_on_job_years ?? 'N/A') . ' years',
                'Pay Frequency' => $application->pay_frequency ?? 'N/A',
                'Paycheck Amount' => '$' . number_format($application->paycheck_amount ?? 0, 2),
            ]],
            'Vehicle Information' => ['fa-car', [
                'Make' => $application->vehicle_make ?? 'N/A',
                'Model' => $application->vehicle_model ?? 'N/A',
                'Year' => $application->vehicle_year ?? 'N/A',
                'Mileage' => $application->vehicle_mileage ?? 'N/A',
                'Trade-in' => ($application->tradein_make ?? '') . ' ' . ($application->tradein_model ?? '') . ' ' . ($application->tradein_year ?? ''),
            ]],
        ];
        @endphp

        @foreach($sections as $title => [$icon, $fields])
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-5 flex items-center space-x-3">
                <div class="w-8 h-8 rounded-xl bg-accent/20 flex items-center justify-center">
                    <i class="fas {{ $icon }} text-accent text-sm"></i>
                </div>
                <span>{{ $title }}</span>
            </h3>
            <div class="grid md:grid-cols-2 gap-4">
                @foreach($fields as $label => $value)
                <div class="bg-white/3 rounded-2xl px-4 py-3">
                    <p class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-1">{{ $label }}</p>
                    <p class="text-sm font-semibold text-white">{{ $value ?: 'N/A' }}</p>
                </div>
                @endforeach
            </div>
        </div>
        @endforeach

        @if($application->additional_comments)
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-3">Additional Comments</h3>
            <p class="text-slate-400 text-sm leading-relaxed">{{ $application->additional_comments }}</p>
        </div>
        @endif
    </div>

    <!-- Sidebar Actions -->
    <div class="space-y-6">
        <!-- Status Card -->
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-5">Application Status</h3>
            <div class="mb-4">
                <span class="badge-{{ $application->status }} text-sm font-black px-4 py-2 rounded-xl capitalize">{{ $application->status }}</span>
            </div>
            <form action="{{ route('admin.financing.status', $application->id) }}" method="POST" class="space-y-4">
                @csrf @method('PATCH')
                <div>
                    <label class="text-xs font-black text-slate-500 uppercase tracking-widest block mb-2">Update Status</label>
                    <select name="status" class="w-full bg-white/5 border border-white/10 rounded-2xl px-4 py-3 text-white text-sm focus:outline-none focus:border-accent">
                        @foreach(['pending','reviewing','approved','rejected'] as $s)
                        <option value="{{ $s }}" {{ $application->status == $s ? 'selected' : '' }} class="bg-slate-900">{{ ucfirst($s) }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-xs font-black text-slate-500 uppercase tracking-widest block mb-2">Admin Notes</label>
                    <textarea name="admin_notes" rows="4" class="w-full bg-white/5 border border-white/10 rounded-2xl px-4 py-3 text-white text-sm focus:outline-none focus:border-accent resize-none" placeholder="Internal notes...">{{ $application->admin_notes }}</textarea>
                </div>
                <button type="submit" class="w-full bg-accent hover:bg-accent-dark py-3 rounded-2xl font-bold text-white text-sm transition-colors">
                    Update Status
                </button>
            </form>
        </div>

        <!-- Meta Info -->
        <div class="glass rounded-3xl p-6 space-y-4">
            <h3 class="font-black text-white">Application Info</h3>
            <div class="space-y-3 text-sm">
                <div class="flex justify-between"><span class="text-slate-500">ID</span><span class="font-bold text-white">#{{ $application->id }}</span></div>
                <div class="flex justify-between"><span class="text-slate-500">Type</span><span class="font-bold text-white capitalize">{{ str_replace('_', ' ', $application->application_type) }}</span></div>
                <div class="flex justify-between"><span class="text-slate-500">Submitted</span><span class="font-bold text-white">{{ \Carbon\Carbon::parse($application->created_at)->format('M j, Y') }}</span></div>
                <div class="flex justify-between"><span class="text-slate-500">IP Address</span><span class="font-bold text-white">{{ $application->ip_address ?? 'N/A' }}</span></div>
                <div class="flex justify-between"><span class="text-slate-500">Consent</span><span class="font-bold {{ $application->consent_given ? 'text-emerald-400' : 'text-rose-400' }}">{{ $application->consent_given ? 'Given' : 'Not Given' }}</span></div>
            </div>
        </div>

        <a href="{{ route('admin.financing.index') }}" class="flex items-center justify-center space-x-2 glass rounded-2xl py-3 text-slate-400 hover:text-white transition-colors text-sm font-bold">
            <i class="fas fa-arrow-left"></i><span>Back to List</span>
        </a>
    </div>
</div>
@endsection
