@extends('admin.layouts.app')
@section('title', 'Dashboard')
@section('page-title', 'Dashboard')
@section('page-subtitle', 'Welcome back! Here\'s what\'s happening today.')

@section('content')
<!-- Stats Grid -->
<div class="grid grid-cols-2 lg:grid-cols-4 gap-5 mb-8">
    @php
    $statCards = [
        ['label' => 'Total Applications', 'value' => $stats['total_applications'], 'icon' => 'fa-file-invoice-dollar', 'color' => 'from-indigo-500 to-purple-600', 'sub' => $stats['pending_applications'] . ' pending'],
        ['label' => 'Unread Messages', 'value' => $stats['unread_messages'], 'icon' => 'fa-envelope', 'color' => 'from-cyan-500 to-blue-600', 'sub' => $stats['total_messages'] . ' total'],
        ['label' => 'Pending Bookings', 'value' => $stats['pending_bookings'], 'icon' => 'fa-calendar-check', 'color' => 'from-amber-500 to-orange-600', 'sub' => $stats['total_bookings'] . ' total'],
        ['label' => 'Newsletter Subs', 'value' => $stats['newsletter_subscribers'], 'icon' => 'fa-users', 'color' => 'from-emerald-500 to-teal-600', 'sub' => 'Active subscribers'],
    ];
    @endphp
    @foreach($statCards as $i => $card)
    <div class="stat-card glass rounded-3xl p-6 neon-border animate-in" style="animation-delay: {{ $i * 0.1 }}s">
        <div class="flex items-start justify-between mb-4">
            <div class="w-12 h-12 rounded-2xl bg-gradient-to-br {{ $card['color'] }} flex items-center justify-center shadow-lg">
                <i class="fas {{ $card['icon'] }} text-white"></i>
            </div>
            <span class="text-xs text-slate-500 font-semibold">{{ now()->format('M Y') }}</span>
        </div>
        <p class="text-4xl font-black text-white mb-1">{{ $card['value'] }}</p>
        <p class="text-sm font-bold text-slate-300">{{ $card['label'] }}</p>
        <p class="text-xs text-slate-500 mt-1">{{ $card['sub'] }}</p>
    </div>
    @endforeach
</div>

<!-- Charts Row -->
<div class="grid lg:grid-cols-3 gap-6 mb-8">
    <!-- Monthly Applications Chart -->
    <div class="lg:col-span-2 glass rounded-3xl p-6">
        <div class="flex items-center justify-between mb-6">
            <div>
                <h3 class="text-lg font-bold text-white">Applications Over Time</h3>
                <p class="text-xs text-slate-500">Last 6 months</p>
            </div>
            <div class="w-8 h-8 rounded-xl bg-indigo-500/20 flex items-center justify-center">
                <i class="fas fa-chart-line text-accent text-sm"></i>
            </div>
        </div>
        <canvas id="applicationsChart" height="120"></canvas>
    </div>

    <!-- Status Breakdown -->
    <div class="glass rounded-3xl p-6">
        <div class="flex items-center justify-between mb-6">
            <div>
                <h3 class="text-lg font-bold text-white">Application Status</h3>
                <p class="text-xs text-slate-500">Breakdown</p>
            </div>
            <div class="w-8 h-8 rounded-xl bg-purple-500/20 flex items-center justify-center">
                <i class="fas fa-chart-pie text-neon-purple text-sm"></i>
            </div>
        </div>
        <canvas id="statusChart" height="200"></canvas>
        <div class="mt-4 space-y-2">
            @foreach($statusBreakdown as $item)
            <div class="flex items-center justify-between text-xs">
                <span class="text-slate-400 capitalize">{{ $item->status }}</span>
                <span class="font-bold text-white">{{ $item->count }}</span>
            </div>
            @endforeach
        </div>
    </div>
</div>

    <!-- Recent Activity -->
    <div class="grid lg:grid-cols-3 gap-6 mb-8">
        <!-- Recent Applications -->
        <div class="glass rounded-3xl p-6">
            <div class="flex items-center justify-between mb-5">
                <h3 class="font-bold text-white">Recent Applications</h3>
                <a href="{{ route('admin.financing.index') }}" class="text-xs text-accent hover:text-accent-light transition-colors">View all →</a>
            </div>
            <div class="space-y-3">
                @forelse($recentApplications as $app)
                <a href="{{ route('admin.financing.show', $app->id) }}" class="flex items-center space-x-3 p-3 rounded-2xl hover:bg-white/5 transition-colors group">
                    <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 flex items-center justify-center text-xs font-black text-accent flex-shrink-0">
                        {{ strtoupper(substr($app->first_name, 0, 1)) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-white truncate">{{ $app->full_name }}</p>
                        <p class="text-xs text-slate-500">{{ \Carbon\Carbon::parse($app->created_at)->diffForHumans() }}</p>
                    </div>
                    <span class="badge-{{ $app->status }} text-[10px] font-bold px-2 py-1 rounded-lg capitalize flex-shrink-0">{{ $app->status }}</span>
                </a>
                @empty
                <p class="text-slate-500 text-sm text-center py-4">No applications yet</p>
                @endforelse
            </div>
        </div>

        <!-- Recent Messages -->
        <div class="glass rounded-3xl p-6">
            <div class="flex items-center justify-between mb-5">
                <h3 class="font-bold text-white">Recent Messages</h3>
                <a href="{{ route('admin.messages.index') }}" class="text-xs text-accent hover:text-accent-light transition-colors">View all →</a>
            </div>
            <div class="space-y-3">
                @forelse($recentMessages as $msg)
                <a href="{{ route('admin.messages.show', $msg->id) }}" class="flex items-center space-x-3 p-3 rounded-2xl hover:bg-white/5 transition-colors">
                    <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-cyan-500/20 to-blue-500/20 flex items-center justify-center text-xs font-black text-neon-cyan flex-shrink-0">
                        {{ strtoupper(substr($msg->name, 0, 1)) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-white truncate">{{ $msg->name }}</p>
                        <p class="text-xs text-slate-500 truncate">{{ Str::limit($msg->message, 30) }}</p>
                    </div>
                    <span class="badge-{{ $msg->status }} text-[10px] font-bold px-2 py-1 rounded-lg capitalize flex-shrink-0">{{ $msg->status }}</span>
                </a>
                @empty
                <p class="text-slate-500 text-sm text-center py-4">No messages yet</p>
                @endforelse
            </div>
        </div>

        <!-- Recent Bookings -->
        <div class="glass rounded-3xl p-6">
            <div class="flex items-center justify-between mb-5">
                <h3 class="font-bold text-white">Recent Bookings</h3>
                <a href="{{ route('admin.bookings.index') }}" class="text-xs text-accent hover:text-accent-light transition-colors">View all →</a>
            </div>
            <div class="space-y-3">
                @forelse($recentBookings as $booking)
                <a href="{{ route('admin.bookings.show', $booking->id) }}" class="flex items-center space-x-3 p-3 rounded-2xl hover:bg-white/5 transition-colors">
                    <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20 flex items-center justify-center text-xs font-black text-neon-amber flex-shrink-0">
                        {{ strtoupper(substr($booking->customer_name, 0, 1)) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-white truncate">{{ $booking->customer_name }}</p>
                        <p class="text-xs text-slate-500 truncate">{{ $booking->service_type }}</p>
                    </div>
                    <span class="badge-{{ $booking->status }} text-[10px] font-bold px-2 py-1 rounded-lg capitalize flex-shrink-0">{{ $booking->status }}</span>
                </a>
                @empty
                <p class="text-slate-500 text-sm text-center py-4">No bookings yet</p>
                @endforelse
            </div>
        </div>
    <!-- Quick Management Hooks -->
    <div class="grid lg:grid-cols-2 gap-6 mb-8">
        <div class="glass rounded-[2rem] p-8 border border-white/5 relative overflow-hidden group">
            <div class="absolute -right-8 -bottom-8 opacity-5 group-hover:opacity-10 transition-opacity rotate-12">
                <i class="fas fa-blog text-9xl"></i>
            </div>
            <div class="relative z-10 flex flex-col md:flex-row md:items-center justify-between gap-6">
                <div>
                    <h3 class="text-2xl font-black text-white italic mb-2">Blog Manager</h3>
                    <p class="text-sm text-slate-500 mb-6 max-w-xs">Share automotive insights and boost your SEO rankings.</p>
                    <div class="flex space-x-4">
                        <a href="{{ route('admin.blogs.create') }}" class="bg-neon-purple hover:bg-neon-purple/80 text-white px-6 py-3 rounded-xl font-bold text-xs shadow-lg shadow-neon-purple/20 transition-all flex items-center">
                            <i class="fas fa-pen-nib mr-2"></i> Write New Post
                        </a>
                        <a href="{{ route('admin.blogs.index') }}" class="glass border border-white/10 text-slate-300 px-6 py-3 rounded-xl font-bold text-xs hover:bg-white/5 transition-all">
                            Manage All
                        </a>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-5xl font-black text-white">{{ $stats['total_blogs'] }}</p>
                    <p class="text-[10px] text-slate-500 uppercase font-black tracking-widest">Articles</p>
                </div>
            </div>
        </div>

        <div class="glass rounded-[2rem] p-8 border border-white/5 relative overflow-hidden group">
            <div class="absolute -right-8 -bottom-8 opacity-5 group-hover:opacity-10 transition-opacity -rotate-12">
                <i class="fas fa-tools text-9xl"></i>
            </div>
            <div class="relative z-10 flex flex-col md:flex-row md:items-center justify-between gap-6">
                <div>
                    <h3 class="text-2xl font-black text-white italic mb-2">Services CMS</h3>
                    <p class="text-sm text-slate-500 mb-6 max-w-xs">Update your service offerings and technical descriptions.</p>
                    <div class="flex space-x-4">
                        <a href="{{ route('admin.services.create') }}" class="bg-neon-cyan hover:bg-neon-cyan/80 text-white px-6 py-3 rounded-xl font-bold text-xs shadow-lg shadow-neon-cyan/20 transition-all flex items-center">
                            <i class="fas fa-plus mr-2"></i> New Service
                        </a>
                        <a href="{{ route('admin.services.index') }}" class="glass border border-white/10 text-slate-300 px-6 py-3 rounded-xl font-bold text-xs hover:bg-white/5 transition-all">
                            View List
                        </a>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-5xl font-black text-white">{{ $stats['total_services'] }}</p>
                    <p class="text-[10px] text-slate-500 uppercase font-black tracking-widest">Services</p>
                </div>
            </div>
        </div>
    </div>

    <!-- SEO & Sitemap Status -->
    <div class="glass rounded-[2.5rem] p-8 border border-white/5 shadow-2xl">
        <div class="flex items-center justify-between mb-8">
            <div>
                <h3 class="text-2xl font-black text-white">SEO Health & Sitemap</h3>
                <p class="text-xs text-slate-500 italic">Organic visibility status</p>
            </div>
            <a href="{{ route('admin.settings.seo') }}" class="w-12 h-12 glass rounded-2xl flex items-center justify-center text-slate-400 hover:text-accent transition-all">
                <i class="fas fa-cog"></i>
            </a>
        </div>
        
        <div class="grid md:grid-cols-4 gap-8 text-center">
            <div class="space-y-2">
                <p class="text-[10px] font-black text-slate-500 uppercase">Sitemap Index</p>
                <a href="{{ url('/sitemap_index.xml') }}" target="_blank" class="text-accent hover:underline font-mono text-xs">sitemap_index.xml</a>
            </div>
            <div class="space-y-2 border-x border-white/5">
                <p class="text-3xl font-black text-neon-green">100%</p>
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Index Health</p>
            </div>
            <div class="space-y-2 border-r border-white/5">
                <p class="text-3xl font-black text-white">{{ $stats['optimized_count'] }}</p>
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Optimized</p>
            </div>
            <div class="space-y-2">
                <p class="text-3xl font-black text-neon-rose text-gradient">{{ $stats['total_blogs'] }}</p>
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Blog Posts</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
const chartDefaults = {
    color: 'rgba(255,255,255,0.6)',
    borderColor: 'rgba(255,255,255,0.05)',
};
Chart.defaults.color = 'rgba(148,163,184,1)';
Chart.defaults.borderColor = 'rgba(255,255,255,0.05)';

// Monthly Applications Chart
const monthlyData = @json($monthlyApplications);
const months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
new Chart(document.getElementById('applicationsChart'), {
    type: 'line',
    data: {
        labels: monthlyData.map(d => months[d.month - 1] + ' ' + d.year),
        datasets: [{
            label: 'Applications',
            data: monthlyData.map(d => d.count),
            borderColor: '#6366f1',
            backgroundColor: 'rgba(99,102,241,0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4,
            pointBackgroundColor: '#6366f1',
            pointBorderColor: '#050810',
            pointBorderWidth: 3,
            pointRadius: 6,
        }]
    },
    options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: {
            x: { grid: { color: 'rgba(255,255,255,0.04)' }, ticks: { color: '#64748b' } },
            y: { grid: { color: 'rgba(255,255,255,0.04)' }, ticks: { color: '#64748b', stepSize: 1 }, beginAtZero: true }
        }
    }
});

// Status Breakdown Doughnut
const statusData = @json($statusBreakdown);
new Chart(document.getElementById('statusChart'), {
    type: 'doughnut',
    data: {
        labels: statusData.map(d => d.status),
        datasets: [{
            data: statusData.map(d => d.count),
            backgroundColor: ['rgba(245,158,11,0.8)', 'rgba(99,102,241,0.8)', 'rgba(16,185,129,0.8)', 'rgba(244,63,94,0.8)'],
            borderColor: '#050810',
            borderWidth: 3,
        }]
    },
    options: {
        responsive: true,
        cutout: '70%',
        plugins: { legend: { display: false } }
    }
});
</script>
@endpush
