@extends('admin.layouts.app')
@section('title', 'Booking #' . $booking->id)
@section('page-title', 'Booking #' . $booking->id)
@section('page-subtitle', $booking->customer_name . ' — ' . $booking->service_type)

@section('content')
<div class="grid lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-6">
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-6 flex items-center space-x-3">
                <div class="w-8 h-8 rounded-xl bg-amber-500/20 flex items-center justify-center"><i class="fas fa-calendar-check text-neon-amber text-sm"></i></div>
                <span>Booking Details</span>
            </h3>
            <div class="grid md:grid-cols-2 gap-4">
                @php $fields = [
                    'Customer Name' => $booking->customer_name,
                    'Email' => $booking->customer_email,
                    'Phone' => $booking->customer_phone,
                    'Service Type' => $booking->service_type,
                    'Preferred Date' => $booking->preferred_date ? \Carbon\Carbon::parse($booking->preferred_date)->format('M j, Y') : 'TBD',
                    'Preferred Time' => $booking->preferred_time ?? 'TBD',
                    'Vehicle Make' => $booking->vehicle_make ?? 'N/A',
                    'Vehicle Model' => $booking->vehicle_model ?? 'N/A',
                    'Vehicle Year' => $booking->vehicle_year ?? 'N/A',
                ]; @endphp
                @foreach($fields as $label => $value)
                <div class="bg-white/3 rounded-2xl px-4 py-3">
                    <p class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-1">{{ $label }}</p>
                    <p class="text-sm font-semibold text-white">{{ $value }}</p>
                </div>
                @endforeach
            </div>
            @if($booking->notes)
            <div class="mt-4 bg-white/3 rounded-2xl px-4 py-3">
                <p class="text-[10px] font-black text-slate-500 uppercase tracking-widest mb-2">Notes</p>
                <p class="text-sm text-slate-300 leading-relaxed">{{ $booking->notes }}</p>
            </div>
            @endif
        </div>
    </div>
    <div class="space-y-6">
        <div class="glass rounded-3xl p-6">
            <h3 class="font-black text-white mb-5">Update Status</h3>
            <div class="mb-4"><span class="badge-{{ $booking->status }} text-sm font-black px-4 py-2 rounded-xl capitalize">{{ $booking->status }}</span></div>
            <form action="{{ route('admin.bookings.status', $booking->id) }}" method="POST" class="space-y-4">
                @csrf @method('PATCH')
                <select name="status" class="w-full bg-white/5 border border-white/10 rounded-2xl px-4 py-3 text-white text-sm focus:outline-none focus:border-accent">
                    @foreach(['pending','confirmed','completed','cancelled'] as $s)
                    <option value="{{ $s }}" {{ $booking->status == $s ? 'selected' : '' }} class="bg-slate-900">{{ ucfirst($s) }}</option>
                    @endforeach
                </select>
                <button type="submit" class="w-full bg-accent hover:bg-accent-dark py-3 rounded-2xl font-bold text-white text-sm transition-colors">Update Status</button>
            </form>
        </div>
        <div class="glass rounded-3xl p-6 space-y-3 text-sm">
            <h3 class="font-black text-white">Meta</h3>
            <div class="flex justify-between"><span class="text-slate-500">Booked</span><span class="font-bold text-white">{{ \Carbon\Carbon::parse($booking->created_at)->format('M j, Y') }}</span></div>
            <div class="flex justify-between"><span class="text-slate-500">Updated</span><span class="font-bold text-white">{{ \Carbon\Carbon::parse($booking->updated_at)->format('M j, Y') }}</span></div>
        </div>
        <a href="{{ route('admin.bookings.index') }}" class="flex items-center justify-center space-x-2 glass rounded-2xl py-3 text-slate-400 hover:text-white transition-colors text-sm font-bold">
            <i class="fas fa-arrow-left"></i><span>Back to Bookings</span>
        </a>
    </div>
</div>
@endsection
