<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Car;
use App\Models\PageContent;

class CmsSeeder extends Seeder
{
    public function run(): void
    {
        // 1. CLEAR EXISTING CONTENT (Optional, but good for fresh start)
        PageContent::truncate();

        // 2. Sample Cars (Keep them as they drive some dynamic parts)
        $cars = [
            [
                'make' => 'Honda',
                'model' => 'NSX',
                'year' => 1991,
                'price' => 89000,
                'market_avg_price' => 95000,
                'vin' => 'JH4NA1150MT000123',
                'stock_number' => 'C-91NSX',
                'type' => 'classic',
                'image' => 'https://upload.wikimedia.org/wikipedia/commons/8/80/Honda%2C_Paris_Motor_Show_2018%2C_Paris_%281Y7A1625%29_%28cropped%29.jpg',
                'description' => 'A legendary supercar in pristine condition. This Series 1 NSX features the highly sought-after manual transmission and has been meticulously maintained. Developed with input from F1 legend Ayrton Senna.',
                'mileage' => '42,086 mi',
                'fuel_type' => 'Gasoline',
                'transmission' => '6-Speed Manual',
                'ext_color' => 'Formula Red',
                'int_color' => 'Black Leather',
                'engine' => '3.0L V6 VTEC',
                'drive_type' => 'RWD',
                'is_featured' => true,
                'status' => 'available',
                'seller_name' => 'Ultimate Auto Care',
            ],
            [
                'make' => 'Volkswagen',
                'model' => 'Beetle',
                'year' => 1967,
                'price' => 24500,
                'market_avg_price' => 28000,
                'vin' => 'VW1172345678',
                'stock_number' => 'C-67BUG',
                'type' => 'classic',
                'image' => 'https://images.unsplash.com/photo-1541899481282-d53bffe3c35d?q=80&w=2070&auto=format&fit=crop',
                'description' => 'Beautifully restored restomod. Combining classic 60s charm with modern reliability. Upgraded front disc brakes and a custom audio system.',
                'mileage' => '12,000 mi',
                'fuel_type' => 'Gasoline',
                'transmission' => '4-Speed Manual',
                'ext_color' => 'Seafoam Green',
                'int_color' => 'Beige Cloth',
                'engine' => '1.6L Air-cooled',
                'drive_type' => 'RWD',
                'is_featured' => true,
                'status' => 'available',
                'seller_name' => 'Ultimate Auto Care',
            ],
            [
                'make' => 'Porsche',
                'model' => '911 Carrera',
                'year' => 1990,
                'price' => 145000,
                'market_avg_price' => 155000,
                'vin' => 'WP0AB2961LS400123',
                'stock_number' => 'C-90P911',
                'type' => 'classic',
                'image' => 'https://www.beverlyhillscarclub.com/wp-content/uploads/2024/07/porsche-964-dealership.jpg',
                'description' => 'Air-cooled legend. Guards Red 964 Carrera 2 with full service history and pristine leather interior.',
                'mileage' => '65,000 mi',
                'fuel_type' => 'Gasoline',
                'transmission' => '5-Speed Manual',
                'ext_color' => 'Guards Red',
                'int_color' => 'Black Leather',
                'engine' => '3.6L Flat-6',
                'drive_type' => 'RWD',
                'is_featured' => true,
                'status' => 'available',
                'seller_name' => 'Ultimate Auto Care',
            ],
        ];

        foreach ($cars as $car) {
            Car::updateOrCreate(['make' => $car['make'], 'model' => $car['model']], $car);
        }

        // 3. MASSIVE PAGE CONTENT SEEDING
        $contents = [
            // ==========================================
            // INDEX.PHP
            // ==========================================
            ['page_name' => 'index.php', 'section_key' => 'hero_badge', 'content_value' => 'CERTIFIED CAR SPECIALISTS'],
            ['page_name' => 'index.php', 'section_key' => 'hero_title', 'content_value' => 'Precision Care for Your Automotive Legends.'],
            ['page_name' => 'index.php', 'section_key' => 'hero_description', 'content_value' => 'From high-tech computer diagnostics to complete engine restoration, we provide expert care for modern performance cars and vintage classics.'],
            
            ['page_name' => 'index.php', 'section_key' => 'stat1_value', 'content_value' => '15+'],
            ['page_name' => 'index.php', 'section_key' => 'stat1_label', 'content_value' => 'Years Exp'],
            ['page_name' => 'index.php', 'section_key' => 'stat2_value', 'content_value' => '5k+'],
            ['page_name' => 'index.php', 'section_key' => 'stat2_label', 'content_value' => 'Happy Clients'],
            
            ['page_name' => 'index.php', 'section_key' => 'services_title', 'content_value' => 'Our Elite Services'],
            ['page_name' => 'index.php', 'section_key' => 'services_description', 'content_value' => 'Expert mechanical solutions tailored to your vehicle\'s specific needs using state-of-the-art diagnostic equipment.'],
            
            ['page_name' => 'index.php', 'section_key' => 'service1_title', 'content_value' => 'Advanced Diagnostics'],
            ['page_name' => 'index.php', 'section_key' => 'service1_desc', 'content_value' => 'State-of-the-art computer mapping and engine diagnostics for high-performance modern vehicles.'],
            ['page_name' => 'index.php', 'section_key' => 'service2_title', 'content_value' => 'Oil Change & Fluids'],
            ['page_name' => 'index.php', 'section_key' => 'service2_desc', 'content_value' => 'Engine oil replacement with premium synthetic options and full fluid checks for transmission, brake, and coolant.'],
            ['page_name' => 'index.php', 'section_key' => 'service3_title', 'content_value' => 'Brakes & Suspension'],
            ['page_name' => 'index.php', 'section_key' => 'service3_desc', 'content_value' => 'Comprehensive brake system service, from pad replacement to rotor resurfacing and suspension tuning.'],
            
            ['page_name' => 'index.php', 'section_key' => 'classics_title', 'content_value' => 'Restored Classics'],
            ['page_name' => 'index.php', 'section_key' => 'classics_description', 'content_value' => 'Discover our curated selection of hand-picked, fully restored vintage cars.'],
            
            ['page_name' => 'index.php', 'section_key' => 'testimonials_badge', 'content_value' => 'TESTIMONIALS'],
            ['page_name' => 'index.php', 'section_key' => 'testimonials_title', 'content_value' => 'Client Stories'],
            
            ['page_name' => 'index.php', 'section_key' => 'testimonial1_quote', 'content_value' => '"The only place I trust with my 1974 Alpha Romeo. Their attention to detail on the engine restoration was absolutely incredible."'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial1_author', 'content_value' => 'John Doe'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial1_role', 'content_value' => 'Collector'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial1_initials', 'content_value' => 'JD'],
            
            ['page_name' => 'index.php', 'section_key' => 'testimonial2_quote', 'content_value' => '"Fast, professionalized diagnostics. They fixed an AC issue that two other shops couldn\'t figure out. Highly recommended."'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial2_author', 'content_value' => 'Sarah Knight'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial2_role', 'content_value' => 'Tesla Owner'],
            ['page_name' => 'index.php', 'section_key' => 'testimonial2_initials', 'content_value' => 'SK'],

            // ==========================================
            // SERVICES.PHP
            // ==========================================
            ['page_name' => 'services.php', 'section_key' => 'page_title', 'content_value' => 'Our Service Catalog'],
            ['page_name' => 'services.php', 'section_key' => 'page_description', 'content_value' => 'From routine maintenance to complex mechanical overhauls, we provide premium care for every vehicle.'],
            
            ['page_name' => 'services.php', 'section_key' => 'stats1_value', 'content_value' => '98%'],
            ['page_name' => 'services.php', 'section_key' => 'stats1_label', 'content_value' => 'Customer Satisfaction'],
            ['page_name' => 'services.php', 'section_key' => 'stats2_value', 'content_value' => '10k+'],
            ['page_name' => 'services.php', 'section_key' => 'stats2_label', 'content_value' => 'Cars Serviced'],
            ['page_name' => 'services.php', 'section_key' => 'stats3_value', 'content_value' => '24/7'],
            ['page_name' => 'services.php', 'section_key' => 'stats3_label', 'content_value' => 'Emergency Support'],
            ['page_name' => 'services.php', 'section_key' => 'stats4_value', 'content_value' => '12mo'],
            ['page_name' => 'services.php', 'section_key' => 'stats4_label', 'content_value' => 'Service Warranty'],

            // ==========================================
            // REPAIR-FINANCING.PHP
            // ==========================================
            ['page_name' => 'repair-financing.php', 'section_key' => 'hero_badge', 'content_value' => 'Service First, Pay Later'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'hero_title', 'content_value' => 'Repair Now, Pay Later. Keep Your Legend Moving.'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'hero_description', 'content_value' => 'Don\'t let unexpected repair costs keep your vehicle off the road. Our flexible financing solutions allow you to spread the cost.'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'why_title', 'content_value' => 'Why Choose Repair Financing?'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'why_description', 'content_value' => 'We understand that car maintenance can sometimes come at the most inconvenient times.'],
            
            ['page_name' => 'repair-financing.php', 'section_key' => 'how_it_works_title', 'content_value' => 'How it Works'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step1_title', 'content_value' => 'Book Your Service'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step1_desc', 'content_value' => 'Schedule your mechanical repair or restoration through our standard booking portal or by calling us.'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step2_title', 'content_value' => 'Select Financing'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step2_desc', 'content_value' => 'During checkout at the service desk or while booking online, choose the "Financing" option to apply.'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step3_title', 'content_value' => 'Ride With Peace'],
            ['page_name' => 'repair-financing.php', 'section_key' => 'step3_desc', 'content_value' => 'Pick a payment plan tailored to your budget, ranging from 3 to 24 month options, and get back on the road.'],

            // ==========================================
            // CAR-FINANCING.PHP
            // ==========================================
            ['page_name' => 'car-financing.php', 'section_key' => 'hero_badge', 'content_value' => 'PREMIUM CAR FINANCING'],
            ['page_name' => 'car-financing.php', 'section_key' => 'hero_title', 'content_value' => 'Drive Your Ambition With Ease.'],
            ['page_name' => 'car-financing.php', 'section_key' => 'hero_description', 'content_value' => 'At Ultimate Auto Care, we believe that luxury and performance should be accessible.'],
            ['page_name' => 'car-financing.php', 'section_key' => 'process_title', 'content_value' => 'Simplified Application Process'],
            ['page_name' => 'car-financing.php', 'section_key' => 'process_desc', 'content_value' => 'We\'ve stripped away the complexity of traditional car loans. pre-approved in under 10 minutes.'],
            ['page_name' => 'car-financing.php', 'section_key' => 'why_plans_title', 'content_value' => 'Why Choose Our Plans?'],

            // ==========================================
            // ABOUT.PHP
            // ==========================================
            ['page_name' => 'about.php', 'section_key' => 'story_badge', 'content_value' => 'OUR STORY'],
            ['page_name' => 'about.php', 'section_key' => 'about_title', 'content_value' => 'Driven by Passion, Defined by Precision.'],
            ['page_name' => 'about.php', 'section_key' => 'about_description', 'content_value' => 'Ultimate Auto Care has been the gold standard for luxury and classic car maintenance for over 15 years.'],
            ['page_name' => 'about.php', 'section_key' => 'stat1_value', 'content_value' => '25+'],
            ['page_name' => 'about.php', 'section_key' => 'stat1_label', 'content_value' => 'Years of Excellence'],
            ['page_name' => 'about.php', 'section_key' => 'mission_title', 'content_value' => 'Our Mission'],
            ['page_name' => 'about.php', 'section_key' => 'mission_desc', 'content_value' => 'To provide uncompromising automotive service that preserves the soul of every vehicle.'],

            // ==========================================
            // CONTACT.PHP
            // ==========================================
            ['page_name' => 'contact.php', 'section_key' => 'contact_title', 'content_value' => 'Get in Touch'],
            ['page_name' => 'contact.php', 'section_key' => 'contact_subtitle', 'content_value' => 'We are here to help you with any questions about our services or inventory.'],
            ['page_name' => 'contact.php', 'section_key' => 'address', 'content_value' => '5270 State Rd 7 North Lauderdale, FL 33319, USA'],
            ['page_name' => 'contact.php', 'section_key' => 'phone', 'content_value' => '(954) 485-4688'],
            ['page_name' => 'contact.php', 'section_key' => 'email', 'content_value' => 'ultimateautocare@gmail.com'],

            // ==========================================
            // FAQ.PHP
            // ==========================================
            ['page_name' => 'faq.php', 'section_key' => 'page_title', 'content_value' => 'Frequently Asked Questions'],
            ['page_name' => 'faq.php', 'section_key' => 'page_subtitle', 'content_value' => 'Find answers to common questions about our services and inventory.'],
        ];

        foreach ($contents as $content) {
            PageContent::updateOrCreate(
                ['page_name' => $content['page_name'], 'section_key' => $content['section_key']],
                ['content_value' => $content['content_value'], 'content_type' => 'text']
            );
        }
    }
}
