<?php

namespace App\Models;

use App\Traits\HasSlug;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasSlug;

    protected $fillable = [
        'title', 'slug', 'content', 'featured_image', 'image_alt', 'status', 'published_at',
        'blog_category_id',
        'meta_title', 'meta_description', 'schema_json', 'canonical_url', 
        'og_title', 'og_description', 'og_image', 'is_index'
    ];

    protected $casts = [
        'published_at' => 'datetime',
        'is_index' => 'boolean',
        'schema_json' => 'array',
    ];

    public function scopePublished($query)
    {
        return $query->where('status', 'published')
                     ->where('published_at', '<=', now());
    }

    public function category()
    {
        return $this->belongsTo(BlogCategory::class, 'blog_category_id');
    }

    public function getMetaTitleAttribute($value)
    {
        return $value ?: $this->title . ' - Ultimate Auto Care Blog';
    }

    public function getMetaDescriptionAttribute($value)
    {
        return $value ?: \Illuminate\Support\Str::limit(strip_tags($this->content), 160);
    }
}
