<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserManagementController extends Controller
{
    public function index()
    {
        global $conn;
        $stmt = $conn->query("SELECT * FROM admin_users ORDER BY created_at DESC");
        $users = array_map(fn($item) => (object)$item, $stmt->fetchAll());
        return view('admin.users.index', compact('users'));
    }

    public function create()
    {
        return view('admin.users.create');
    }

    public function store(Request $request)
    {
        global $conn;
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:admin_users',
            'password' => 'required|min:8|confirmed',
            'role' => 'required|in:admin,super_admin',
        ]);

        $sql = "INSERT INTO admin_users (name, email, password, role, is_active, created_at, updated_at) VALUES (?, ?, ?, ?, ?, NOW(), NOW())";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            $request->name, $request->email, Hash::make($request->password), 
            $request->role, $request->has('is_active') ? 1 : 0
        ]);

        return redirect()->route('admin.users.index')->with('success', 'Admin user created successfully.');
    }

    public function edit($id)
    {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE id = ?");
        $stmt->execute([$id]);
        $user = (object)$stmt->fetch();
        if (!$user || !isset($user->id)) abort(404);
        
        return view('admin.users.edit', compact('user'));
    }

    public function update(Request $request, $id)
    {
        global $conn;
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'role' => 'required|in:admin,super_admin',
        ]);

        $sql = "UPDATE admin_users SET name=?, email=?, role=?, is_active=?, updated_at=NOW()";
        $params = [$request->name, $request->email, $request->role, $request->has('is_active') ? 1 : 0];

        if ($request->filled('password')) {
            $request->validate(['password' => 'min:8|confirmed']);
            $sql .= ", password=?";
            $params[] = Hash::make($request->password);
        }

        $sql .= " WHERE id=?";
        $params[] = $id;

        $stmt = $conn->prepare($sql);
        $stmt->execute($params);

        return redirect()->route('admin.users.index')->with('success', 'User updated successfully.');
    }

    public function destroy($id)
    {
        global $conn;
        if ((int)$id === (int)auth('admin')->id()) {
            return back()->with('error', 'You cannot delete your own account.');
        }
        $stmt = $conn->prepare("DELETE FROM admin_users WHERE id = ?");
        $stmt->execute([$id]);
        return redirect()->route('admin.users.index')->with('success', 'User deleted.');
    }
}
