<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactMessage;
use Illuminate\Http\Request;

class MessagesController extends Controller
{
    public function index(Request $request)
    {
        global $conn;
        $sql = "SELECT * FROM contact_messages WHERE 1=1";
        $params = [];
        
        if ($request->filled('status')) {
            $sql .= " AND status = ?";
            $params[] = $request->status;
        }
        
        if ($request->filled('search')) {
            $s = "%" . $request->search . "%";
            $sql .= " AND (name LIKE ? OR email LIKE ?)";
            $params[] = $s;
            $params[] = $s;
        }
        
        $sql .= " ORDER BY created_at DESC";
        
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $messages_raw = $stmt->fetchAll();
        $messages = array_map(fn($item) => (object)$item, $messages_raw);
        
        return view('admin.messages.index', compact('messages'));
    }

    public function show($id)
    {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM contact_messages WHERE id = ? LIMIT 1");
        $stmt->execute([$id]);
        $message = (object)$stmt->fetch();
        
        if (!$message || !isset($message->id)) abort(404);

        if ($message->status === 'unread') {
            $upd = $conn->prepare("UPDATE contact_messages SET status = 'read' WHERE id = ?");
            $upd->execute([$id]);
            $message->status = 'read';
        }
        
        return view('admin.messages.show', compact('message'));
    }

    public function reply(Request $request, $id)
    {
        global $conn;
        $request->validate(['admin_reply' => 'required|string']);
        
        $upd = $conn->prepare("UPDATE contact_messages SET admin_reply = ?, status = 'replied' WHERE id = ?");
        $upd->execute([$request->admin_reply, $id]);
        
        return back()->with('success', 'Reply saved.');
    }

    public function destroy($id)
    {
        global $conn;
        $del = $conn->prepare("DELETE FROM contact_messages WHERE id = ?");
        $del->execute([$id]);
        
        return redirect()->route('admin.messages.index')->with('success', 'Message deleted.');
    }
}
