<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PageContent;
use Illuminate\Http\Request;

class CmsController extends Controller
{
    public function index()
    {
        global $conn;
        // Get all PHP files in the root directory (one level up from public)
        $rootPath = base_path('..');
        $files = glob($rootPath . '/*.php');
        
        $pages = [];
        $exclude = ['cookie.txt', 'test.php']; // Add any files to exclude
        
        foreach ($files as $file) {
            $name = basename($file);
            if (!in_array($name, $exclude)) {
                $stmt = $conn->prepare("SELECT COUNT(*) FROM page_contents WHERE page_name = ?");
                $stmt->execute([$name]);
                $exists = $stmt->fetchColumn() > 0;

                $pages[] = (object)[
                    'page_name' => $name,
                    'is_configured' => $exists
                ];
            }
        }

        return view('admin.cms.index', compact('pages'));
    }

    public function editPage($pageName)
    {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM page_contents WHERE page_name = ?");
        $stmt->execute([$pageName]);
        $contents_raw = $stmt->fetchAll();
        $contents = array_map(fn($item) => (object)$item, $contents_raw);

        return view('admin.cms.edit', compact('pageName', 'contents'));
    }

    public function updateContent(Request $request)
    {
        global $conn;
        $request->validate([
            'contents' => 'required|array',
            'contents.*.id' => 'required',
            'contents.*.content_value' => 'required|string',
        ]);

        foreach ($request->contents as $content) {
            $upd = $conn->prepare("UPDATE page_contents SET content_value = ? WHERE id = ?");
            $upd->execute([$content['content_value'], $content['id']]);
        }

        return back()->with('success', 'Page content updated successfully.');
    }
}
