
<?php $__env->startSection('title', 'Edit Vehicle'); ?>
<?php $__env->startSection('page-title', 'Edit: ' . $car->make . ' ' . $car->model); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-8 border border-white/5 shadow-2xl">
        <form action="<?php echo e(route('admin.cars.update', $car)); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Make</label>
                    <input type="text" name="make" value="<?php echo e($car->make); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Model Name</label>
                    <input type="text" name="model" value="<?php echo e($car->model); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">VIN Number</label>
                    <input type="text" name="vin" value="<?php echo e($car->vin); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Stock Number</label>
                    <input type="text" name="stock_number" value="<?php echo e($car->stock_number); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Year</label>
                    <input type="number" name="year" value="<?php echo e($car->year); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Listing Price ($)</label>
                    <input type="number" name="price" value="<?php echo e((int)$car->price); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all" required>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Market Avg Price ($)</label>
                    <input type="number" name="market_avg_price" value="<?php echo e((int)$car->market_avg_price); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Vehicle Type</label>
                    <select name="type" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="classic" <?php echo e($car->type == 'classic' ? 'selected' : ''); ?>>Classic</option>
                        <option value="pre-owned" <?php echo e($car->type == 'pre-owned' ? 'selected' : ''); ?>>Pre-owned</option>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Exterior Color</label>
                    <input type="text" name="ext_color" value="<?php echo e($car->ext_color); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Interior Color</label>
                    <input type="text" name="int_color" value="<?php echo e($car->int_color); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Engine</label>
                    <input type="text" name="engine" value="<?php echo e($car->engine); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Drive Type</label>
                    <input type="text" name="drive_type" value="<?php echo e($car->drive_type); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="space-y-2">
                <label class="text-sm font-bold text-slate-400 ml-1">Car Description & Details</label>
                <textarea name="description" rows="4" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all"><?php echo e($car->description); ?></textarea>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Fuel Type</label>
                    <input type="text" name="fuel_type" value="<?php echo e($car->fuel_type); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Transmission</label>
                    <input type="text" name="transmission" value="<?php echo e($car->transmission); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Mileage</label>
                    <input type="text" name="mileage" value="<?php echo e($car->mileage); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Update Image</label>
                        <div class="flex items-center space-x-4">
                            <?php if($car->image): ?>
                            <img src="<?php echo e($car->image); ?>" class="w-20 h-12 rounded-lg object-cover border border-white/10">
                            <?php endif; ?>
                            <input type="file" name="image" class="w-full bg-white/5 border border-white/10 rounded-2xl py-2 px-6 text-white focus:outline-none transition-all">
                        </div>
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400 ml-1">Image Alt Text (SEO)</label>
                        <input type="text" name="image_alt" value="<?php echo e($car->image_alt); ?>" placeholder="Describe the image for screen readers and SEO" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                    </div>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Seller Name</label>
                    <input type="text" name="seller_name" value="<?php echo e($car->seller_name); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6 p-6 bg-accent/5 rounded-3xl border border-accent/10">
                <div class="col-span-2">
                    <h3 class="text-lg font-bold text-accent mb-4">SEO Optimization</h3>
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">URL Slug</label>
                    <input type="text" name="slug" value="<?php echo e($car->slug); ?>" placeholder="auto-generated-if-empty" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Title</label>
                    <input type="text" name="meta_title" value="<?php echo e($car->meta_title); ?>" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                </div>
                <div class="col-span-2 space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Meta Description</label>
                    <textarea name="meta_description" rows="2" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all"><?php echo e($car->meta_description); ?></textarea>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div class="space-y-2">
                    <label class="text-sm font-bold text-slate-400 ml-1">Status</label>
                    <select name="status" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all">
                        <option value="available" <?php echo e($car->status == 'available' ? 'selected' : ''); ?>>Available</option>
                        <option value="sold" <?php echo e($car->status == 'sold' ? 'selected' : ''); ?>>Sold</option>
                    </select>
                </div>
                <div class="flex items-center space-x-3 pt-8">
                    <input type="checkbox" name="is_featured" value="1" id="is_featured" <?php echo e($car->is_featured ? 'checked' : ''); ?> class="w-5 h-5 rounded border-white/10 bg-white/5 text-accent focus:ring-accent">
                    <label for="is_featured" class="text-sm font-bold text-white">Feature on Homepage</label>
                </div>
            </div>

            <div class="pt-6 border-t border-white/5 flex space-x-4">
                <button type="submit" class="flex-1 bg-accent hover:bg-accent-dark text-white py-4 rounded-2xl font-bold text-lg transition-all shadow-xl shadow-accent/20">
                    Update Vehicle
                </button>
                <a href="<?php echo e(route('admin.cars.index')); ?>" class="px-8 py-4 rounded-2xl bg-white/5 text-slate-400 font-bold hover:bg-white/10 transition-all border border-white/10">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\Cars site\ultimate-auto-admin\resources\views/admin/cars/edit.blade.php ENDPATH**/ ?>