
<?php $__env->startSection('title', 'New Blog Post'); ?>
<?php $__env->startSection('page-title', 'Tell a Story'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-8 border border-white/5 shadow-2xl">
        <form action="<?php echo e(route('admin.blogs.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-8">
            <?php echo csrf_field(); ?>
            
            <div class="space-y-2">
                <label class="text-sm font-bold text-slate-400">Article Title</label>
                <input type="text" name="title" placeholder="Why Regular Oil Changes Matter..." class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white text-2xl font-bold" required>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="md:col-span-2 space-y-2">
                    <label class="text-sm font-bold text-slate-400">Post Content (HTML Supported)</label>
                    <textarea name="content" rows="15" placeholder="Start writing..." class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white font-mono text-sm"></textarea>
                </div>

                <div class="space-y-6">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Featured Image</label>
                        <input type="file" name="image" class="w-full bg-white/5 border border-white/10 rounded-2xl py-2 px-4 text-xs text-white">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Image Alt Text</label>
                        <input type="text" name="image_alt" placeholder="Mechanic working on car" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 text-xs text-white">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Category</label>
                        <select name="blog_category_id" class="w-full bg-dark-700 border border-white/10 rounded-xl py-3 px-4 text-white text-sm">
                            <option value="">Select Category</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Status</label>
                        <select name="status" class="w-full bg-dark-700 border border-white/10 rounded-xl py-3 px-4 text-white text-sm">
                            <option value="draft">Draft</option>
                            <option value="published">Published</option>
                        </select>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Publish Date</label>
                        <input type="date" name="published_at" class="w-full bg-white/5 border border-white/10 rounded-xl py-3 px-4 text-white text-sm">
                    </div>
                </div>
            </div>

            
            <div class="p-8 bg-neon-purple/5 rounded-[2.5rem] border border-neon-purple/10 space-y-6">
                <h3 class="text-xl font-black text-neon-purple flex items-center">
                    <i class="fas fa-search mr-3"></i> SEO & URL Management
                </h3>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Custom Slug</label>
                        <input type="text" name="slug" placeholder="custom-url-path (auto-gen if empty)" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm">
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Meta Title</label>
                        <input type="text" name="meta_title" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm">
                    </div>
                    <div class="col-span-2 space-y-2">
                        <label class="text-sm font-bold text-slate-400">Meta Description</label>
                        <textarea name="meta_description" rows="2" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm"></textarea>
                    </div>
                </div>
            </div>

            <div class="flex space-x-4 pt-4">
                <button type="submit" class="flex-1 bg-neon-purple hover:bg-neon-purple/80 text-white py-4 rounded-2xl font-bold text-lg transition-all shadow-xl shadow-neon-purple/20">
                    Publish Story
                </button>
                <a href="<?php echo e(route('admin.blogs.index')); ?>" class="px-8 py-4 rounded-2xl bg-white/5 text-slate-400 font-bold hover:bg-white/10 transition-all border border-white/10">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\Cars site\ultimate-auto-admin\resources\views/admin/blogs/create.blade.php ENDPATH**/ ?>