
<?php $__env->startSection('title', 'Car Shop CRM'); ?>
<?php $__env->startSection('page-title', 'Car Shop CRM'); ?>
<?php $__env->startSection('page-subtitle', 'Manage your inventory and shop visibility.'); ?>

<?php $__env->startSection('content'); ?>
<div class="glass-strong rounded-3xl overflow-hidden border border-white/5 shadow-2xl">
    <div class="px-8 py-6 border-b border-white/5 flex flex-col md:row items-center justify-between space-y-4 md:space-y-0">
        <div>
            <h3 class="text-xl font-bold text-white">Car Inventory</h3>
            <p class="text-xs text-slate-500">Add or modify car details directly.</p>
        </div>
        <a href="<?php echo e(route('admin.cars.create')); ?>" class="bg-accent hover:bg-accent-dark text-white px-6 py-3 rounded-2xl font-bold transition-all shadow-lg flex items-center space-x-2">
            <i class="fas fa-plus"></i>
            <span>Add New Car</span>
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-white/5 text-[10px] uppercase tracking-widest font-black text-slate-400">
                    <th class="px-6 py-4">Vehicle</th>
                    <th class="px-6 py-4">Price</th>
                    <th class="px-6 py-4">Type</th>
                    <th class="px-6 py-4">Status</th>
                    <th class="px-6 py-4">Featured</th>
                    <th class="px-6 py-4 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-white/5 text-sm">
                <?php $__empty_1 = true; $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-white/5 transition-colors group">
                    <td class="px-6 py-4">
                        <div class="flex items-center space-x-4">
                            <div class="w-16 h-10 rounded-lg overflow-hidden glass border border-white/10">
                                <?php if($car->image): ?>
                                    <img src="<?php echo e($car->image); ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center bg-slate-800 text-slate-500">
                                        <i class="fas fa-car text-xs"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <p class="font-bold text-white"><?php echo e($car->year); ?> <?php echo e($car->make); ?> <?php echo e($car->model); ?></p>
                                <p class="text-[10px] text-slate-500 uppercase"><?php echo e($car->mileage ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 font-black text-accent">$<?php echo e(number_format($car->price)); ?></td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 rounded-md text-[10px] font-bold uppercase bg-white/5 text-slate-400"><?php echo e($car->type); ?></span>
                    </td>
                    <td class="px-6 py-4">
                        <span class="badge-<?php echo e($car->status); ?> text-[10px] font-bold px-2 py-1 rounded-lg capitalize"><?php echo e($car->status); ?></span>
                    </td>
                    <td class="px-6 py-4">
                        <div class="w-8 h-8 rounded-full flex items-center justify-center <?php echo e($car->is_featured ? 'text-yellow-400' : 'text-slate-700'); ?>">
                            <i class="fas fa-star"></i>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right space-x-2">
                        <a href="<?php echo e(route('admin.cars.edit', $car->id)); ?>" class="text-slate-400 hover:text-accent transition-colors"><i class="fas fa-edit"></i></a>
                        <form action="<?php echo e(route('admin.cars.destroy', $car->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this vehicle?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-slate-600 hover:text-neon-rose transition-colors"><i class="fas fa-trash-alt"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-slate-500">No cars in inventory</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($cars->hasPages()): ?>
    <div class="px-6 py-4 border-t border-white/5">
        <?php echo e($cars->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/u784207861/domains/shahwaizsamiahmed.com/public_html/backend/resources/views/admin/cars/index.blade.php ENDPATH**/ ?>