
<?php $__env->startSection('title', 'Bookings'); ?>
<?php $__env->startSection('page-title', 'Service Bookings'); ?>
<?php $__env->startSection('page-subtitle', 'Manage all service appointments'); ?>

<?php $__env->startSection('content'); ?>
<div class="glass rounded-3xl p-5 mb-6 flex flex-wrap gap-4 items-center">
    <form method="GET" class="flex flex-wrap gap-3 flex-1">
        <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search bookings..." class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white placeholder-slate-500 focus:outline-none focus:border-accent flex-1 min-w-48">
        <select name="status" class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white focus:outline-none focus:border-accent">
            <option value="">All</option>
            <?php $__currentLoopData = ['pending','confirmed','completed','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($s); ?>" <?php echo e(request('status') == $s ? 'selected' : ''); ?> class="bg-slate-900"><?php echo e(ucfirst($s)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button type="submit" class="bg-accent hover:bg-accent-dark px-6 py-3 rounded-2xl text-white font-bold text-sm transition-colors"><i class="fas fa-search mr-2"></i>Filter</button>
        <?php if(request()->hasAny(['search','status'])): ?><a href="<?php echo e(route('admin.bookings.index')); ?>" class="bg-white/5 hover:bg-white/10 px-6 py-3 rounded-2xl text-slate-400 font-bold text-sm transition-colors">Clear</a><?php endif; ?>
    </form>
</div>
<div class="glass rounded-3xl overflow-hidden">
    <table class="w-full">
        <thead><tr class="border-b border-white/5">
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Customer</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden md:table-cell">Service</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden lg:table-cell">Date</th>
            <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Status</th>
            <th class="px-6 py-4 text-right text-xs font-black text-slate-500 uppercase tracking-widest">Actions</th>
        </tr></thead>
        <tbody class="divide-y divide-white/5">
            <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="hover:bg-white/3 transition-colors">
                <td class="px-6 py-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20 flex items-center justify-center text-xs font-black text-neon-amber flex-shrink-0"><?php echo e(strtoupper(substr($booking->customer_name, 0, 1))); ?></div>
                        <div><p class="text-sm font-bold text-white"><?php echo e($booking->customer_name); ?></p><p class="text-xs text-slate-500"><?php echo e($booking->customer_email); ?></p></div>
                    </div>
                </td>
                <td class="px-6 py-4 hidden md:table-cell"><p class="text-sm text-slate-400"><?php echo e($booking->service_type); ?></p></td>
                <td class="px-6 py-4 hidden lg:table-cell"><span class="text-xs text-slate-500"><?php echo e($booking->preferred_date ? \Carbon\Carbon::parse($booking->preferred_date)->format('M j, Y') : 'TBD'); ?></span></td>
                <td class="px-6 py-4"><span class="badge-<?php echo e($booking->status); ?> text-xs font-bold px-3 py-1.5 rounded-xl capitalize"><?php echo e($booking->status); ?></span></td>
                <td class="px-6 py-4 text-right">
                    <div class="flex items-center justify-end space-x-2">
                        <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>" class="w-8 h-8 rounded-xl bg-accent/10 hover:bg-accent/20 flex items-center justify-center text-accent transition-colors"><i class="fas fa-eye text-xs"></i></a>
                        <form action="<?php echo e(route('admin.bookings.destroy', $booking->id)); ?>" method="POST" onsubmit="return confirm('Delete?')"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?><button type="submit" class="w-8 h-8 rounded-xl bg-rose-500/10 hover:bg-rose-500/20 flex items-center justify-center text-rose-400 transition-colors"><i class="fas fa-trash text-xs"></i></button></form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="5" class="px-6 py-16 text-center text-slate-500">No bookings found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php if($bookings->hasPages()): ?><div class="px-6 py-4 border-t border-white/5"><?php echo e($bookings->withQueryString()->links()); ?></div><?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\Cars site\ultimate-auto-admin\resources\views/admin/bookings/index.blade.php ENDPATH**/ ?>