<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FinancingController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Admin\MessagesController;
use App\Http\Controllers\Admin\BookingsController;


Route::get('/sitemap.xml', function () {
    return response()->file(public_path('sitemap.xml'));
})->name('sitemap');

Route::get('/sitemap_index.xml', function () {
    return response()->file(public_path('sitemap_index.xml'));
})->name('sitemap.index');

// =============================
// ADMIN ROOT REDIRECT
// =============================
Route::get('/', function () {
    return redirect('/admin/login');
});

// =============================
// ADMIN ROUTES
// =============================
Route::prefix('admin')->name('admin.')->group(function () {

    // -------------------------
    // Authentication
    // -------------------------
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // -------------------------
    // Protected Admin Routes
    // -------------------------
    Route::middleware([\App\Http\Middleware\AdminAuthenticate::class])->group(function () {

        Route::get('/', fn() => redirect()->route('admin.dashboard'));
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // Financing
        Route::prefix('financing')->name('financing.')->group(function () {
            Route::get('/', [FinancingController::class, 'index'])->name('index');
            Route::get('/{application}', [FinancingController::class, 'show'])->name('show');
            Route::patch('/{application}/status', [FinancingController::class, 'updateStatus'])->name('status');
            Route::delete('/{application}', [FinancingController::class, 'destroy'])->name('destroy');
        });

        // Messages
        Route::prefix('messages')->name('messages.')->group(function () {
            Route::get('/', [MessagesController::class, 'index'])->name('index');
            Route::get('/{message}', [MessagesController::class, 'show'])->name('show');
            Route::post('/{message}/reply', [MessagesController::class, 'reply'])->name('reply');
            Route::delete('/{message}', [MessagesController::class, 'destroy'])->name('destroy');
        });

        // Bookings
        Route::prefix('bookings')->name('bookings.')->group(function () {
            Route::get('/', [BookingsController::class, 'index'])->name('index');
            Route::get('/{booking}', [BookingsController::class, 'show'])->name('show');
            Route::patch('/{booking}/status', [BookingsController::class, 'updateStatus'])->name('status');
            Route::delete('/{booking}', [BookingsController::class, 'destroy'])->name('destroy');
        });

        // Resource Controllers
        Route::resources([
            'users'     => UserManagementController::class,
            'cars'      => \App\Http\Controllers\Admin\CarsController::class,
            'services'  => \App\Http\Controllers\Admin\ServiceController::class,
            'blogs'     => \App\Http\Controllers\Admin\BlogManagementController::class,
        ]);

        // CMS
        Route::prefix('cms')->name('cms.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\CmsController::class, 'index'])->name('index');
            Route::get('/{page_name}', [\App\Http\Controllers\Admin\CmsController::class, 'editPage'])->name('edit');
            Route::post('/update', [\App\Http\Controllers\Admin\CmsController::class, 'updateContent'])->name('update');
        });

        // SEO Settings
        Route::get('/settings/seo', [DashboardController::class, 'seoSettings'])->name('settings.seo');
        Route::post('/settings/seo', [DashboardController::class, 'updateSeoSettings'])->name('settings.seo.update');
    });
});