@extends('layouts.main')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-12">
    <div class="text-center mb-16">
        <h1 class="text-6xl font-black mb-6">Our <span class="text-gradient">Services</span></h1>
        <p class="text-text-muted text-lg max-w-2xl mx-auto italic">Expert automotive care for modern performance vehicles and timeless vintage legends.</p>
    </div>

    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach($services as $service)
        <div class="glass p-10 rounded-[2.5rem] border border-white/5 hover:border-accent/30 transition-all group">
            <div class="w-16 h-16 bg-accent/10 rounded-2xl flex items-center justify-center text-accent mb-8 group-hover:scale-110 transition-transform">
                <i class="fas {{ $service->icon ?: 'fa-tools' }} text-2xl"></i>
            </div>
            <h3 class="text-3xl font-bold mb-4">{{ $service->title }}</h3>
            <p class="text-slate-400 mb-8 leading-relaxed">{{ $service->description }}</p>
            <a href="{{ route('services.show', $service->slug) }}" class="inline-flex items-center space-x-2 text-accent font-black hover:translate-x-3 transition-transform">
                <span>Explore Service</span>
                <i class="fas fa-arrow-right text-sm"></i>
            </a>
        </div>
        @endforeach
    </div>
</div>
@endsection
