@extends('layouts.main')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-12">
    <h1 class="text-5xl font-black mb-12">Automotive <span class="text-accent">Insights</span></h1>
    
    <div class="grid lg:grid-cols-3 gap-12">
        <div class="lg:col-span-2 space-y-12">
            @foreach($blogs as $blog)
            <article class="glass rounded-[2.5rem] overflow-hidden border border-white/5 hover:border-accent/20 transition-all group">
                <div class="aspect-video relative overflow-hidden">
                    <img src="{{ asset($blog->featured_image ?? 'assets/images/blog-placeholder.jpg') }}" 
                         alt="{{ $blog->image_alt ?? $blog->title }}" 
                         class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-700">
                </div>
                <div class="p-10">
                    <div class="flex items-center space-x-4 mb-6">
                        <span class="bg-accent/10 text-accent text-xs font-bold px-3 py-1 rounded-full uppercase">{{ $blog->category->name ?? 'General' }}</span>
                        <span class="text-text-muted text-sm">{{ $blog->published_at->format('M d, Y') }}</span>
                    </div>
                    <h2 class="text-3xl font-bold mb-4 group-hover:text-accent transition-colors">
                        <a href="{{ route('blogs.show', $blog->slug) }}">{{ $blog->title }}</a>
                    </h2>
                    <p class="text-text-muted mb-8 line-clamp-3">
                        {{ Str::limit(strip_tags($blog->content), 200) }}
                    </p>
                    <a href="{{ route('blogs.show', $blog->slug) }}" class="inline-flex items-center space-x-2 text-accent font-bold group-hover:translate-x-2 transition-transform">
                        <span>Read Full Story</span>
                        <i class="fas fa-arrow-right text-sm"></i>
                    </a>
                </div>
            </article>
            @endforeach
            
            <div class="mt-12">
                {{ $blogs->links() }}
            </div>
        </div>
        
        <div class="space-y-8">
            <div class="glass p-8 rounded-3xl border border-white/5">
                <h3 class="text-xl font-bold mb-6 italic">Popular Topics</h3>
                <div class="flex flex-wrap gap-3">
                    {{-- Categories loop here --}}
                    <span class="bg-white/5 px-4 py-2 rounded-xl text-sm hover:bg-accent hover:text-primary transition-all cursor-pointer">Restoration</span>
                    <span class="bg-white/5 px-4 py-2 rounded-xl text-sm hover:bg-accent hover:text-primary transition-all cursor-pointer">Maintenance</span>
                    <span class="bg-white/5 px-4 py-2 rounded-xl text-sm hover:bg-accent hover:text-primary transition-all cursor-pointer">Classic Market</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
