@extends('admin.layouts.app')
@section('title', 'User Management')
@section('page-title', 'User Management')
@section('page-subtitle', 'Manage admin accounts and permissions')

@section('content')
<div class="flex justify-end mb-6">
    <a href="{{ route('admin.users.create') }}" class="bg-gradient-to-r from-accent to-neon-purple px-6 py-3 rounded-2xl font-bold text-white text-sm flex items-center space-x-2 hover:opacity-90 transition-opacity shadow-lg shadow-accent/20">
        <i class="fas fa-plus"></i><span>Add Admin User</span>
    </a>
</div>

<div class="glass rounded-3xl overflow-hidden">
    <table class="w-full">
        <thead>
            <tr class="border-b border-white/5">
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">User</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden md:table-cell">Role</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden lg:table-cell">Last Login</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Status</th>
                <th class="px-6 py-4 text-right text-xs font-black text-slate-500 uppercase tracking-widest">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-white/5">
            @forelse($users as $user)
            <tr class="hover:bg-white/3 transition-colors">
                <td class="px-6 py-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-neon-purple/30 to-accent/30 flex items-center justify-center text-sm font-black text-white flex-shrink-0">
                            {{ strtoupper(substr($user->name, 0, 1)) }}
                        </div>
                        <div>
                            <p class="text-sm font-bold text-white flex items-center gap-2">
                                {{ $user->name }}
                                @if($user->id === auth('admin')->id())
                                <span class="text-[10px] bg-accent/20 text-accent px-2 py-0.5 rounded-full font-bold">You</span>
                                @endif
                            </p>
                            <p class="text-xs text-slate-500">{{ $user->email }}</p>
                        </div>
                    </div>
                </td>
                <td class="px-6 py-4 hidden md:table-cell">
                    <span class="text-xs font-bold px-3 py-1.5 rounded-xl capitalize
                        {{ $user->role === 'super_admin' ? 'bg-purple-500/15 text-purple-400 border border-purple-500/30' : 'bg-indigo-500/15 text-indigo-400 border border-indigo-500/30' }}">
                        {{ str_replace('_', ' ', $user->role) }}
                    </span>
                </td>
                <td class="px-6 py-4 hidden lg:table-cell">
                    <span class="text-xs text-slate-500">{{ $user->last_login_at ? \Carbon\Carbon::parse($user->last_login_at)->diffForHumans() : 'Never' }}</span>
                </td>
                <td class="px-6 py-4">
                    <span class="text-xs font-bold px-3 py-1.5 rounded-xl
                        {{ $user->is_active ? 'bg-emerald-500/15 text-emerald-400 border border-emerald-500/30' : 'bg-rose-500/15 text-rose-400 border border-rose-500/30' }}">
                        {{ $user->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </td>
                <td class="px-6 py-4 text-right">
                    <div class="flex items-center justify-end space-x-2">
                        <a href="{{ route('admin.users.edit', $user->id) }}" class="w-8 h-8 rounded-xl bg-accent/10 hover:bg-accent/20 flex items-center justify-center text-accent transition-colors">
                            <i class="fas fa-edit text-xs"></i>
                        </a>
                        @if($user->id !== auth('admin')->id())
                        <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" onsubmit="return confirm('Delete this admin user?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="w-8 h-8 rounded-xl bg-rose-500/10 hover:bg-rose-500/20 flex items-center justify-center text-rose-400 transition-colors">
                                <i class="fas fa-trash text-xs"></i>
                            </button>
                        </form>
                        @endif
                    </div>
                </td>
            </tr>
            @empty
            <tr><td colspan="5" class="px-6 py-16 text-center text-slate-500">No users found.</td></tr>
            @endforelse
        </tbody>
    </table>
    @if($users->hasPages())
    <div class="px-6 py-4 border-t border-white/5">{{ $users->withQueryString()->links() }}</div>
    @endif
</div>
@endsection
