@extends('admin.layouts.app')
@section('title', 'Create Admin User')
@section('page-title', 'Create Admin User')
@section('page-subtitle', 'Add a new administrator account')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="glass rounded-3xl p-8">
        <form action="{{ route('admin.users.store') }}" method="POST" class="space-y-6" x-data="{ showPass: false, showConfirm: false }">
            @csrf
            @if($errors->any())
            <div class="bg-rose-500/10 border border-rose-500/30 rounded-2xl px-5 py-4 text-rose-400 text-sm space-y-1">
                @foreach($errors->all() as $error)<p>• {{ $error }}</p>@endforeach
            </div>
            @endif

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-black text-slate-500 uppercase tracking-widest mb-3">Full Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                           class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-3.5 text-white text-sm focus:outline-none focus:border-accent transition-colors"
                           placeholder="John Doe">
                </div>
                <div>
                    <label class="block text-xs font-black text-slate-500 uppercase tracking-widest mb-3">Email Address *</label>
                    <input type="email" name="email" value="{{ old('email') }}" required
                           class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-3.5 text-white text-sm focus:outline-none focus:border-accent transition-colors"
                           placeholder="admin@example.com">
                </div>
            </div>

            <div>
                <label class="block text-xs font-black text-slate-500 uppercase tracking-widest mb-3">Role *</label>
                <select name="role" class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-3.5 text-white text-sm focus:outline-none focus:border-accent">
                    <option value="admin" class="bg-slate-900">Admin</option>
                    <option value="super_admin" class="bg-slate-900">Super Admin</option>
                </select>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-black text-slate-500 uppercase tracking-widest mb-3">Password *</label>
                    <div class="relative">
                        <input :type="showPass ? 'text' : 'password'" name="password" required
                               class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-3.5 pr-12 text-white text-sm focus:outline-none focus:border-accent transition-colors"
                               placeholder="Min 8 characters">
                        <button type="button" @click="showPass = !showPass" class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 hover:text-slate-300">
                            <i class="fas" :class="showPass ? 'fa-eye-slash' : 'fa-eye'"></i>
                        </button>
                    </div>
                </div>
                <div>
                    <label class="block text-xs font-black text-slate-500 uppercase tracking-widest mb-3">Confirm Password *</label>
                    <div class="relative">
                        <input :type="showConfirm ? 'text' : 'password'" name="password_confirmation" required
                               class="w-full bg-white/5 border border-white/10 rounded-2xl px-5 py-3.5 pr-12 text-white text-sm focus:outline-none focus:border-accent transition-colors"
                               placeholder="Repeat password">
                        <button type="button" @click="showConfirm = !showConfirm" class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 hover:text-slate-300">
                            <i class="fas" :class="showConfirm ? 'fa-eye-slash' : 'fa-eye'"></i>
                        </button>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-3">
                <input type="checkbox" name="is_active" id="is_active" value="1" checked class="w-4 h-4 rounded accent-indigo-500">
                <label for="is_active" class="text-sm text-slate-300 cursor-pointer">Account is active</label>
            </div>

            <div class="flex items-center space-x-4 pt-2">
                <button type="submit" class="bg-gradient-to-r from-accent to-neon-purple px-8 py-3.5 rounded-2xl font-bold text-white text-sm hover:opacity-90 transition-opacity">
                    <i class="fas fa-user-plus mr-2"></i>Create User
                </button>
                <a href="{{ route('admin.users.index') }}" class="px-8 py-3.5 rounded-2xl font-bold text-slate-400 text-sm hover:text-white transition-colors glass">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
