@extends('admin.layouts.app')
@section('title', 'Edit Service')
@section('page-title', 'Edit: ' . $service->title)

@section('content')
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-8 border border-white/5 shadow-2xl">
        <form action="{{ route('admin.services.update', $service) }}" method="POST" enctype="multipart/form-data" class="space-y-8">
            @csrf
            @method('PATCH')
            
            <div class="grid md:grid-cols-2 gap-8">
                <div class="space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Service Title</label>
                        <input type="text" name="title" value="{{ $service->title }}" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white" required>
                    </div>
                    
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Short Description</label>
                        <textarea name="description" rows="3" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white">{{ $service->description }}</textarea>
                    </div>

                    <div class="flex items-center space-x-3 pt-4">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ $service->is_active ? 'checked' : '' }} class="w-5 h-5 rounded border-white/10 bg-white/5 text-accent">
                        <label for="is_active" class="text-sm font-bold text-white">Active & Searchable</label>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">FontAwesome Icon Class</label>
                        <div class="flex items-center space-x-4">
                            <div class="w-12 h-12 glass rounded-xl flex items-center justify-center text-accent">
                                <i class="fas {{ $service->icon ?: 'fa-tools' }} text-xl"></i>
                            </div>
                            <input type="text" name="icon" value="{{ $service->icon }}" placeholder="fa-tools" class="flex-1 bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm">
                        </div>
                    </div>
                </div>

                <div class="space-y-6">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Est. Starting Price</label>
                        <input type="text" name="price_starting_from" value="{{ $service->price_starting_from }}" placeholder="From $100" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Service Image</label>
                        <div class="flex items-center space-x-4">
                            @if($service->featured_image)
                            <img src="{{ $service->featured_image }}" class="w-24 h-16 rounded-xl object-cover border border-white/10">
                            @endif
                            <input type="file" name="image" class="w-full bg-white/5 border border-white/10 rounded-2xl py-2 px-6 text-white text-sm">
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Image Alt Text (SEO)</label>
                        <input type="text" name="image_alt" value="{{ $service->image_alt }}" placeholder="Classic car engine repair" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white text-sm">
                    </div>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-8">
                {{-- Benefits Section --}}
                <div class="space-y-4" x-data="{ benefits: {{ json_encode($service->benefits ?? []) }} }">
                    <label class="text-sm font-bold text-slate-400">Key Benefits</label>
                    <div class="space-y-2">
                        <template x-for="(benefit, index) in benefits" :key="index">
                            <div class="flex items-center space-x-2">
                                <input type="text" :name="'benefits['+index+']'" x-model="benefits[index]" class="flex-1 bg-white/5 border border-white/10 rounded-xl py-2 px-4 text-white text-sm">
                                <button type="button" @click="benefits.splice(index, 1)" class="text-neon-rose"><i class="fas fa-times-circle"></i></button>
                            </div>
                        </template>
                        <button type="button" @click="benefits.push('')" class="text-accent text-xs font-bold uppercase tracking-widest">+ Add Benefit</button>
                    </div>
                </div>

                {{-- Features Section --}}
                <div class="space-y-4" x-data="{ features: {{ json_encode($service->features ?? []) }} }">
                    <label class="text-sm font-bold text-slate-400">What's Included</label>
                    <div class="space-y-2">
                        <template x-for="(feature, index) in features" :key="index">
                            <div class="flex items-center space-x-2">
                                <input type="text" :name="'features['+index+']'" x-model="features[index]" class="flex-1 bg-white/5 border border-white/10 rounded-xl py-2 px-4 text-white text-sm">
                                <button type="button" @click="features.splice(index, 1)" class="text-neon-rose"><i class="fas fa-times-circle"></i></button>
                            </div>
                        </template>
                        <button type="button" @click="features.push('')" class="text-accent text-xs font-bold uppercase tracking-widest">+ Add Feature</button>
                    </div>
                </div>
            </div>

            {{-- Full Content --}}
            <div class="space-y-2">
                <label class="text-sm font-bold text-slate-400">Full Service Content (HTML Support)</label>
                <textarea name="content" rows="10" class="w-full bg-white/5 border border-white/10 rounded-2xl py-4 px-6 text-white font-mono text-sm">{{ $service->content }}</textarea>
            </div>

            {{-- SEO Section --}}
            <div class="p-8 bg-accent/5 rounded-[2rem] border border-accent/10 space-y-6">
                <h3 class="text-xl font-black text-accent flex items-center">
                    <i class="fas fa-search-dollar mr-3"></i> Search Engine Optimization
                </h3>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">URL Slug</label>
                        <input type="text" name="slug" value="{{ $service->slug }}" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white">
                        <p class="text-[10px] text-slate-500 italic ml-1">Relative to /service/...</p>
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-bold text-slate-400">Meta Title</label>
                        <input type="text" name="meta_title" value="{{ $service->meta_title }}" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white">
                    </div>
                    <div class="col-span-2 space-y-2">
                        <label class="text-sm font-bold text-slate-400">Meta Description</label>
                        <textarea name="meta_description" rows="2" class="w-full bg-dark-700 border border-white/10 rounded-2xl py-4 px-6 text-white">{{ $service->meta_description }}</textarea>
                    </div>
                </div>
            </div>

            <div class="flex space-x-4 pt-4">
                <button type="submit" class="flex-1 bg-accent hover:bg-accent-dark text-white py-4 rounded-2xl font-bold text-lg transition-all shadow-xl shadow-accent/20">
                    Update Service Details
                </button>
                <a href="{{ route('admin.services.index') }}" class="px-8 py-4 rounded-2xl bg-white/5 text-slate-400 font-bold hover:bg-white/10 transition-all border border-white/10">
                    Back to List
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
