@extends('admin.layouts.app')
@section('title', 'Financing Applications')
@section('page-title', 'Financing Applications')
@section('page-subtitle', 'Manage all car sale & repair financing applications')

@section('content')
<!-- Filters -->
<div class="glass rounded-3xl p-5 mb-6 flex flex-wrap gap-4 items-center">
    <form method="GET" class="flex flex-wrap gap-3 flex-1">
        <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by name or email..."
               class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white placeholder-slate-500 focus:outline-none focus:border-accent flex-1 min-w-48">
        <select name="status" class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white focus:outline-none focus:border-accent">
            <option value="">All Statuses</option>
            @foreach(['pending','reviewing','approved','rejected'] as $s)
            <option value="{{ $s }}" {{ request('status') == $s ? 'selected' : '' }} class="bg-slate-900">{{ ucfirst($s) }}</option>
            @endforeach
        </select>
        <select name="type" class="bg-white/5 border border-white/10 rounded-2xl px-5 py-3 text-sm text-white focus:outline-none focus:border-accent">
            <option value="">All Types</option>
            <option value="car_sale" {{ request('type') == 'car_sale' ? 'selected' : '' }} class="bg-slate-900">Car Sale</option>
            <option value="repair" {{ request('type') == 'repair' ? 'selected' : '' }} class="bg-slate-900">Repair</option>
        </select>
        <button type="submit" class="bg-accent hover:bg-accent-dark px-6 py-3 rounded-2xl text-white font-bold text-sm transition-colors">
            <i class="fas fa-search mr-2"></i>Filter
        </button>
        @if(request()->hasAny(['search','status','type']))
        <a href="{{ route('admin.financing.index') }}" class="bg-white/5 hover:bg-white/10 px-6 py-3 rounded-2xl text-slate-400 font-bold text-sm transition-colors">Clear</a>
        @endif
    </form>
    <div class="text-xs text-slate-500 font-semibold">{{ count($applications) }} total</div>
</div>

<!-- Table -->
<div class="glass rounded-3xl overflow-hidden">
    <table class="w-full">
        <thead>
            <tr class="border-b border-white/5">
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Applicant</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden md:table-cell">Type</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden lg:table-cell">Loan Amount</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest">Status</th>
                <th class="px-6 py-4 text-left text-xs font-black text-slate-500 uppercase tracking-widest hidden lg:table-cell">Date</th>
                <th class="px-6 py-4 text-right text-xs font-black text-slate-500 uppercase tracking-widest">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-white/5">
            @forelse($applications as $app)
            <tr class="hover:bg-white/3 transition-colors">
                <td class="px-6 py-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 flex items-center justify-center text-xs font-black text-accent flex-shrink-0">
                            {{ strtoupper(substr($app->first_name, 0, 1)) }}
                        </div>
                        <div>
                            <p class="text-sm font-bold text-white">{{ $app->first_name }} {{ $app->last_name }}</p>
                            <p class="text-xs text-slate-500">{{ $app->email }}</p>
                        </div>
                    </div>
                </td>
                <td class="px-6 py-4 hidden md:table-cell">
                    <span class="text-xs font-bold text-slate-400 capitalize">{{ str_replace('_', ' ', $app->application_type) }}</span>
                </td>
                <td class="px-6 py-4 hidden lg:table-cell">
                    <span class="text-sm font-bold text-white">${{ number_format($app->desired_loan_amount ?? 0, 0) }}</span>
                </td>
                <td class="px-6 py-4">
                    <span class="badge-{{ $app->status }} text-xs font-bold px-3 py-1.5 rounded-xl capitalize">{{ $app->status }}</span>
                </td>
                <td class="px-6 py-4 hidden lg:table-cell">
                    <span class="text-xs text-slate-500">{{ \Carbon\Carbon::parse($app->created_at)->format('M j, Y') }}</span>
                </td>
                <td class="px-6 py-4 text-right">
                    <div class="flex items-center justify-end space-x-2">
                        <a href="{{ route('admin.financing.show', $app->id) }}" class="w-8 h-8 rounded-xl bg-accent/10 hover:bg-accent/20 flex items-center justify-center text-accent transition-colors">
                            <i class="fas fa-eye text-xs"></i>
                        </a>
                        <form action="{{ route('admin.financing.destroy', $app->id) }}" method="POST" onsubmit="return confirm('Delete this application?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="w-8 h-8 rounded-xl bg-rose-500/10 hover:bg-rose-500/20 flex items-center justify-center text-rose-400 transition-colors">
                                <i class="fas fa-trash text-xs"></i>
                            </button>
                        </form>
                    </div>
                </td>
            </tr>
            @empty
            <tr><td colspan="6" class="px-6 py-16 text-center text-slate-500">No applications found.</td></tr>
            @endforelse
        </tbody>
    </table>
    @if($applications->hasPages())
    <div class="px-6 py-4 border-t border-white/5">
        {{ $applications->withQueryString()->links() }}
    </div>
    @endif
</div>
@endsection
