@extends('admin.layouts.app')
@section('title', 'CMS / Page Builder')
@section('page-title', 'Page Builder')
@section('page-subtitle', 'Modify frontend content directly from here.')

@section('content')
<div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
    @foreach($pages as $page)
    <div class="glass-strong rounded-[2.5rem] p-8 border border-white/5 hover:border-accent/30 transition-all group relative overflow-hidden">
        <div class="absolute top-0 right-0 p-6 opacity-10 group-hover:opacity-20 transition-opacity">
            <i class="fas fa-file-code text-6xl"></i>
        </div>
        
        <h3 class="text-2xl font-black text-white mb-2">{{ ucfirst(str_replace('.php', '', $page->page_name)) }}</h3>
        <p class="text-[10px] text-slate-500 uppercase tracking-[0.2em] font-bold mb-8">
            {{ $page->page_name }} • 
            @if($page->is_configured)
                <span class="text-green-500">Configured</span>
            @else
                <span class="text-slate-600 italic">Not Seeded</span>
            @endif
        </p>
        
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.cms.edit', ['page_name' => $page->page_name]) }}" class="flex-1 bg-accent hover:bg-accent-dark text-white text-center py-4 rounded-2xl font-bold transition-all shadow-lg animate-glow">
                Edit Content
            </a>
            <a href="http://localhost:8000/{{ $page->page_name }}" target="_blank" class="w-14 h-14 glass flex items-center justify-center rounded-2xl text-slate-400 hover:text-white transition-all">
                <i class="fas fa-external-link-alt"></i>
            </a>
        </div>
    </div>
    @endforeach

    <!-- Add New Page Mockup -->
    <div class="glass border-2 border-dashed border-white/10 rounded-[2.5rem] p-8 flex flex-col items-center justify-center text-center cursor-not-allowed opacity-50">
        <div class="w-16 h-16 rounded-full bg-white/5 flex items-center justify-center mb-4">
            <i class="fas fa-plus text-slate-500"></i>
        </div>
        <h3 class="font-bold text-slate-400">Add New Page</h3>
        <p class="text-xs text-slate-600">Coming Soon</p>
    </div>
</div>
@endsection
