@extends('admin.layouts.app')
@section('title', 'Edit Page Content')
@section('page-title', 'Editing: ' . ucfirst(str_replace('.php', '', $pageName)))
@section('page-subtitle', 'Update text and headings for this page.')

@section('content')
<div class="max-w-5xl mx-auto">
    <div class="glass-strong rounded-3xl p-10 border border-white/5 shadow-2xl relative overflow-hidden">
        <div class="flex items-center justify-between mb-10">
            <div>
                <h3 class="text-2xl font-black text-white">Live Editor</h3>
                <p class="text-sm text-slate-500">Changes apply immediately to the frontend.</p>
            </div>
            <div class="flex items-center space-x-3">
                <a href="{{ route('admin.cms.index') }}" class="text-sm font-bold text-slate-400 hover:text-white transition-colors">Back to List</a>
            </div>
        </div>

        <form action="{{ route('admin.cms.update') }}" method="POST" class="space-y-8">
            @csrf
            
            <div class="space-y-6">
                @forelse($contents as $index => $content)
                <div class="glass p-6 rounded-2xl border border-white/5 group hover:border-accent/20 transition-all">
                    <div class="flex items-center justify-between mb-4">
                        <label class="text-[10px] uppercase tracking-widest font-black text-accent bg-accent/10 px-3 py-1 rounded-full">
                            {{ str_replace('_', ' ', $content->section_key) }}
                        </label>
                        <span class="text-[10px] text-slate-600 font-bold uppercase">{{ $content->content_type }}</span>
                    </div>
                    
                    <input type="hidden" name="contents[{{ $index }}][id]" value="{{ $content->id }}">
                    
                    @if(strlen($content->content_value) > 100 || $content->content_type == 'html')
                    <textarea name="contents[{{ $index }}][content_value]" rows="4" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all font-jakarta">{{ $content->content_value }}</textarea>
                    @else
                    <input type="text" name="contents[{{ $index }}][content_value]" value="{{ $content->content_value }}" class="w-full bg-white/5 border border-white/10 rounded-xl py-4 px-6 text-white focus:outline-none focus:border-accent transition-all font-jakarta text-lg font-bold">
                    @endif
                </div>
                @empty
                <div class="text-center py-20 glass rounded-3xl border border-dashed border-white/10">
                    <i class="fas fa-ghost text-5xl text-slate-700 mb-6"></i>
                    <h4 class="text-xl font-bold text-slate-400">No editable sections found</h4>
                    <p class="text-sm text-slate-600 mt-2">This page hasn't been configured for CMS editing yet.</p>
                </div>
                @endforelse
            </div>

            <div class="pt-10 border-t border-white/5 flex items-center justify-between">
                <p class="text-xs text-slate-500"><i class="fas fa-info-circle mr-2 text-accent"></i> Make sure to review your changes before saving.</p>
                <button type="submit" class="bg-accent hover:bg-accent-dark text-white px-10 py-4 rounded-2xl font-black text-lg transition-all shadow-xl shadow-accent/40 animate-glow">
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
