@extends('admin.layouts.app')
@section('title', 'Blog Management')
@section('page-title', 'Automotive Blog')

@section('content')
<div class="flex flex-col space-y-6">
    <div class="flex justify-between items-center">
        <p class="text-slate-400">Write and optimize blog posts for search engines and readers.</p>
        <a href="{{ route('admin.blogs.create') }}" class="bg-neon-purple hover:bg-neon-purple/80 text-white px-6 py-3 rounded-xl font-bold transition-all flex items-center shadow-lg shadow-neon-purple/20">
            <i class="fas fa-pen-nib mr-2"></i> Write New Post
        </a>
    </div>

    <div class="glass-strong rounded-3xl overflow-hidden border border-white/5">
        <table class="w-full text-left">
            <thead>
                <tr class="bg-white/5 text-slate-400 text-xs uppercase tracking-widest font-black">
                    <th class="px-6 py-4">Article</th>
                    <th class="px-6 py-4">Category</th>
                    <th class="px-6 py-4">Publish Date</th>
                    <th class="px-6 py-4">SEO</th>
                    <th class="px-6 py-4 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-white/5">
                @foreach($blogs as $blog)
                <tr class="group hover:bg-white/5 transition-colors">
                    <td class="px-6 py-4">
                        <div class="flex items-center space-x-4">
                            <div class="w-16 h-10 rounded-lg overflow-hidden glass">
                                <img src="{{ $blog->featured_image ?? asset('assets/images/placeholder.jpg') }}" class="w-full h-full object-cover">
                            </div>
                            <p class="font-bold text-white">{{ $blog->title }}</p>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-xs text-slate-400 font-medium">
                        <span class="bg-white/5 px-3 py-1 rounded-lg border border-white/5 italic">
                            {{ $blog->category->name ?? 'Uncategorized' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-sm text-slate-500">{{ $blog->published_at ? \Carbon\Carbon::parse($blog->published_at)->format('M d, Y') : 'Draft' }}</td>
                    <td class="px-6 py-4">
                        <span class="px-3 py-1 rounded-full text-[10px] font-black uppercase {{ $blog->meta_title ? 'badge-approved' : 'badge-pending' }}">
                            {{ $blog->meta_title ? 'Optimized' : 'Missing' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex justify-end space-x-2">
                            <a href="{{ route('admin.blogs.edit', $blog->id) }}" class="w-8 h-8 rounded-lg glass flex items-center justify-center text-slate-400 hover:text-accent transition-all">
                                <i class="fas fa-edit text-xs"></i>
                            </a>
                            <form action="{{ route('admin.blogs.destroy', $blog->id) }}" method="POST" onsubmit="return confirm('Delete this post?')">
                                @csrf @method('DELETE')
                                <button class="w-8 h-8 rounded-lg glass flex items-center justify-center text-slate-400 hover:text-neon-rose transition-all">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="p-4 border-t border-white/5">
            {{ $blogs->links() }}
        </div>
    </div>
</div>
@endsection
