<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('page_contents', function (Blueprint $table) {
            $table->id();
            $table->string('page_name')->index(); // index.php, about.php, etc.
            $table->string('section_key')->index(); // hero_title, contact_email, etc.
            $table->string('content_type')->default('text'); // text, html, image
            $table->text('content_value');
            $table->timestamps();
            
            $table->unique(['page_name', 'section_key']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('page_contents');
    }
};
