<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->string('make');
            $table->string('model');
            $table->integer('year');
            $table->decimal('price', 15, 2);
            $table->string('type')->default('classic'); // classic, pre-owned
            $table->string('image')->nullable();
            $table->text('description')->nullable();
            $table->string('fuel_type')->default('Petrol');
            $table->string('transmission')->default('Manual');
            $table->string('mileage')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->string('status')->default('available'); // available, sold
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cars');
    }
};
