<?php
/**
 * Database configuration loader using .env file
 * Compatible with shared hosting
 */

// ---------- LOAD .env FILE ----------
$envPath = __DIR__ . '/.env';

if (file_exists($envPath)) {
    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue;
        }

        list($name, $value) = explode('=', $line, 2);

        $name = trim($name);
        $value = trim($value);

        // Remove quotes
        $value = trim($value, '"');

        $_ENV[$name] = $value;
        $_SERVER[$name] = $value;
        putenv("$name=$value");
    }
}

// ---------- DATABASE VALUES FROM .env ----------
$db_host = $_ENV['DB_HOST'] ?? '127.0.0.1';
$db_name = $_ENV['DB_DATABASE'] ?? '';
$db_user = $_ENV['DB_USERNAME'] ?? '';
$db_pass = $_ENV['DB_PASSWORD'] ?? '';

// ---------- PDO CONNECTION ----------
try {
    $conn_str = "mysql:host={$db_host};dbname={$db_name};charset=utf8mb4";

    $pdo = new PDO($conn_str, $db_user, $db_pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    // Global connection
    $conn = $pdo;
    $GLOBALS['conn'] = $pdo;

} catch (PDOException $e) {
    die("Database Connection failed: " . $e->getMessage());
}