<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FinancingApplication extends Model
{
    protected $fillable = [
        'application_type', 'status', 'desired_loan_amount', 'desired_monthly_payment',
        'selected_vehicle', 'down_payment', 'first_name', 'last_name', 'address',
        'landmark', 'city', 'state', 'zip_code', 'country', 'daytime_phone',
        'evening_phone', 'fax', 'email', 'ssn_last4', 'date_of_birth',
        'residence_type', 'mortgage_rent_payment', 'time_at_residence_years',
        'prior_address', 'account_types', 'drivers_license_number',
        'drivers_license_state', 'drivers_license_expiry', 'employer_name',
        'employer_address', 'employer_city', 'employer_state', 'employer_zip',
        'employer_country', 'business_phone', 'employment_status', 'occupation',
        'time_on_job_years', 'pay_frequency', 'paycheck_amount', 'other_income_types',
        'other_income_detail', 'vehicle_make', 'vehicle_model', 'vehicle_year',
        'vehicle_mileage', 'tradein_make', 'tradein_model', 'tradein_year',
        'tradein_mileage', 'additional_comments', 'consent_given', 'ip_address', 'admin_notes'
    ];

    protected $casts = [
        'account_types' => 'array',
        'other_income_types' => 'array',
        'consent_given' => 'boolean',
        'date_of_birth' => 'date',
        'drivers_license_expiry' => 'date',
    ];

    public function getFullNameAttribute(): string
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function getStatusColorAttribute(): string
    {
        return match($this->status) {
            'approved' => 'green',
            'rejected' => 'red',
            'reviewing' => 'yellow',
            default => 'blue',
        };
    }
}
