<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Car;
use App\Models\PageContent;
use Illuminate\Http\Request;

class FrontendController extends Controller
{
    public function getCars()
    {
        $cars = Car::where('status', 'available')->get();
        return response()->json([
            'success' => true,
            'data' => $cars
        ]);
    }

    public function getPageContent(Request $request)
    {
        $pageName = $request->query('page', 'index.php');
        $contents = PageContent::where('page_name', $pageName)->pluck('content_value', 'section_key');
        
        return response()->json([
            'success' => true,
            'data' => $contents
        ]);
    }
}
