<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactMessage;
use Illuminate\Http\Request;

class MessagesController extends Controller
{
    public function index(Request $request)
    {
        $query = ContactMessage::query();

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        if ($request->filled('search')) {
            $search = '%' . $request->search . '%';
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', $search)
                  ->orWhere('email', 'like', $search);
            });
        }

        $messages = $query->latest()->paginate(10);
        
        return view('admin.messages.index', compact('messages'));
    }

    public function show($id)
    {
        $message = ContactMessage::findOrFail($id);
        
        if ($message->status === 'unread') {
            $message->update(['status' => 'read']);
        }
        
        return view('admin.messages.show', compact('message'));
    }

    public function reply(Request $request, $id)
    {
        $message = ContactMessage::findOrFail($id);
        $request->validate(['admin_reply' => 'required|string']);
        
        $message->update([
            'admin_reply' => $request->admin_reply,
            'status' => 'replied'
        ]);
        
        return back()->with('success', 'Reply saved.');
    }

    public function destroy($id)
    {
        $message = ContactMessage::findOrFail($id);
        $message->delete();
        
        return redirect()->route('admin.messages.index')->with('success', 'Message deleted.');
    }
}
