<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ServiceBooking;
use Illuminate\Http\Request;

class BookingsController extends Controller
{
    public function index(Request $request)
    {
        $query = ServiceBooking::query();

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        if ($request->filled('search')) {
            $search = '%' . $request->search . '%';
            $query->where(function($q) use ($search) {
                $q->where('customer_name', 'like', $search)
                  ->orWhere('customer_email', 'like', $search);
            });
        }

        $bookings = $query->latest()->paginate(10);
        
        return view('admin.bookings.index', compact('bookings'));
    }

    public function show($id)
    {
        $booking = ServiceBooking::findOrFail($id);
        return view('admin.bookings.show', compact('booking'));
    }

    public function updateStatus(Request $request, $id)
    {
        $booking = ServiceBooking::findOrFail($id);
        $request->validate(['status' => 'required|in:pending,confirmed,completed,cancelled']);
        
        $booking->update(['status' => $request->status]);
        
        return back()->with('success', 'Booking status updated.');
    }

    public function destroy($id)
    {
        $booking = ServiceBooking::findOrFail($id);
        $booking->delete();
        
        return redirect()->route('admin.bookings.index')->with('success', 'Booking deleted.');
    }
}
